/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Misc;
import io.questdb.std.Mutable;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Sinkable;
import io.questdb.std.str.StringSink;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ByteList
implements Mutable,
Sinkable {
    private static final int DEFAULT_ARRAY_SIZE = 16;
    private static final byte NO_ENTRY_VALUE = -1;
    private final int initialCapacity;
    private byte[] data;
    private int pos = 0;

    public ByteList() {
        this(16);
    }

    public ByteList(int capacity) {
        this.initialCapacity = capacity;
        this.data = new byte[this.initialCapacity];
    }

    public void add(byte value) {
        this.checkCapacity(this.pos + 1);
        this.data[this.pos++] = value;
    }

    public void addAll(ByteList that) {
        int p = this.pos;
        int s = that.size();
        this.setPos(p + s);
        System.arraycopy(that.data, 0, this.data, p, s);
    }

    public int capacity() {
        return this.data.length;
    }

    @Override
    public void clear() {
        this.pos = 0;
    }

    public void clear(int capacity) {
        this.checkCapacity(capacity);
        this.pos = 0;
        Arrays.fill(this.data, (byte)-1);
    }

    public boolean contains(byte value) {
        return this.indexOf(value, 0, this.pos) > -1;
    }

    public boolean equals(Object that) {
        return this == that || that instanceof ByteList && this.equals((ByteList)that);
    }

    public void extendAndSet(int index, byte value) {
        this.checkCapacity(index + 1);
        if (index >= this.pos) {
            this.pos = index + 1;
        }
        this.data[index] = value;
    }

    public byte get(int index) {
        return this.getQuick(index);
    }

    public byte getLast() {
        if (this.pos > 0) {
            return this.data[this.pos - 1];
        }
        return -1;
    }

    public byte getQuick(int index) {
        assert (index < this.pos);
        return this.data[index];
    }

    public int hashCode() {
        int hashCode = 1;
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            byte v = this.getQuick(i);
            hashCode = 31 * hashCode + (v == -1 ? (byte)0 : v);
        }
        return hashCode;
    }

    public int indexOf(byte v, int low, int high) {
        assert (high <= this.pos);
        for (int i = low; i < high; ++i) {
            byte f = this.data[i];
            if (f != v) continue;
            return i;
        }
        return -1;
    }

    public void insert(int index, byte value) {
        this.setPos(++this.pos);
        System.arraycopy(this.data, index, this.data, index + 1, this.pos - index - 1);
        this.data[index] = value;
    }

    public void remove(byte key) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (key != this.getQuick(i)) continue;
            this.removeIndex(i);
            return;
        }
    }

    public void removeIndex(int index) {
        if (this.pos < 1 || index >= this.pos) {
            return;
        }
        int move = this.pos - index - 1;
        if (move > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, move);
        }
        int index1 = --this.pos;
        this.data[index1] = -1;
    }

    public void restoreInitialCapacity() {
        this.data = new byte[this.initialCapacity];
        this.pos = 0;
    }

    public void set(int index, byte value) {
        if (index < this.pos) {
            this.data[index] = value;
            return;
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public void setAll(int capacity, byte value) {
        this.checkCapacity(capacity);
        this.pos = capacity;
        Arrays.fill(this.data, 0, this.pos, value);
    }

    public void setPos(int position) {
        this.checkCapacity(position);
        this.pos = position;
    }

    public void setQuick(int index, byte value) {
        assert (index < this.pos);
        this.data[index] = value;
    }

    public int size() {
        return this.pos;
    }

    @Override
    public void toSink(@NotNull CharSink<?> sink) {
        sink.putAscii('[');
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            if (i > 0) {
                sink.putAscii(',');
            }
            sink.put(this.get(i));
        }
        sink.putAscii(']');
    }

    public void toSink(CharSink<?> sink, int exceptValue) {
        sink.putAscii('[');
        boolean pastFirst = false;
        int k = this.size();
        for (int i = 0; i < k; ++i) {
            byte val;
            if (pastFirst) {
                sink.putAscii(',');
            }
            if ((val = this.get(i)) == exceptValue) continue;
            sink.put(val);
            pastFirst = true;
        }
        sink.putAscii(']');
    }

    public String toString() {
        StringSink b = Misc.getThreadLocalSink();
        this.toSink(b);
        return ((Object)b).toString();
    }

    public void zero(byte value) {
        Arrays.fill(this.data, 0, this.pos, value);
    }

    private void checkCapacity(int capacity) {
        int l = this.data.length;
        if (capacity > l) {
            int newCap = Math.max(l << 1, capacity);
            byte[] buf = new byte[newCap];
            System.arraycopy(this.data, 0, buf, 0, l);
            this.data = buf;
        }
    }

    private boolean equals(ByteList that) {
        if (this.pos != that.pos) {
            return false;
        }
        int n = this.pos;
        for (int i = 0; i < n; ++i) {
            if (this.getQuick(i) == that.getQuick(i)) continue;
            return false;
        }
        return true;
    }
}

