/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.groupby.vect;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.groupby.vect.DistinctFunc;
import io.questdb.griffin.engine.groupby.vect.KeyValueFunc;
import io.questdb.griffin.engine.groupby.vect.VectorAggregateFunction;
import io.questdb.std.Rosti;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import java.util.Arrays;

public class NSumDoubleVectorAggregateFunction
extends DoubleFunction
implements VectorAggregateFunction {
    private static final int COUNT_PADDING = 8;
    private static final int SUM_PADDING = 9;
    private final int columnIndex;
    private final long[] count;
    private final DistinctFunc distinctFunc;
    private final KeyValueFunc keyValueFunc;
    private final double[] sum;
    private final int workerCount;
    private double transientC;
    private long transientCount;
    private double transientSum;
    private int valueOffset;

    public NSumDoubleVectorAggregateFunction(int keyKind, int columnIndex, int workerCount) {
        this.columnIndex = columnIndex;
        this.sum = new double[workerCount * 9];
        this.count = new long[workerCount * 8];
        this.workerCount = workerCount;
        if (keyKind == 1) {
            this.distinctFunc = Rosti::keyedHourDistinct;
            this.keyValueFunc = Rosti::keyedHourNSumDouble;
        } else {
            this.distinctFunc = Rosti::keyedIntDistinct;
            this.keyValueFunc = Rosti::keyedIntNSumDouble;
        }
    }

    @Override
    public void aggregate(long address, long frameRowCount, int workerId) {
        double x;
        if (address != 0L && (x = Vect.sumDoubleNeumaier(address, frameRowCount)) == x) {
            int sumOffset = workerId * 9;
            double sum = this.sum[sumOffset];
            double t = sum + x;
            double c = this.sum[sumOffset + 1];
            c = Math.abs(sum) >= x ? (c += sum - t + x) : (c += x - t + sum);
            this.sum[sumOffset] = t;
            this.sum[sumOffset + 1] = c;
            int n = workerId * 8;
            this.count[n] = this.count[n] + 1L;
        }
    }

    @Override
    public boolean aggregate(long pRosti, long keyAddress, long valueAddress, long frameRowCount) {
        if (valueAddress == 0L) {
            return this.distinctFunc.run(pRosti, keyAddress, frameRowCount);
        }
        return this.keyValueFunc.run(pRosti, keyAddress, valueAddress, frameRowCount, this.valueOffset);
    }

    @Override
    public void clear() {
        Arrays.fill(this.sum, 0.0);
        Arrays.fill(this.count, 0L);
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public double getDouble(Record rec) {
        this.computeSum();
        return this.transientCount > 0L ? this.transientSum + this.transientC : Double.NaN;
    }

    @Override
    public String getName() {
        return "nsum";
    }

    @Override
    public int getValueOffset() {
        return this.valueOffset;
    }

    @Override
    public void initRosti(long pRosti) {
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset), 0.0);
        Unsafe.getUnsafe().putDouble(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 1), 0.0);
        Unsafe.getUnsafe().putLong(Rosti.getInitialValueSlot(pRosti, this.valueOffset + 2), 0L);
    }

    @Override
    public boolean merge(long pRostiA, long pRostiB) {
        return Rosti.keyedIntNSumDoubleMerge(pRostiA, pRostiB, this.valueOffset);
    }

    @Override
    public void pushValueTypes(ArrayColumnTypes types) {
        this.valueOffset = types.getColumnCount();
        types.add(10);
        types.add(10);
        types.add(6);
    }

    @Override
    public boolean wrapUp(long pRosti) {
        this.computeSum();
        return Rosti.keyedIntNSumDoubleWrapUp(pRosti, this.valueOffset, this.transientSum, this.transientCount, this.transientC);
    }

    private void computeSum() {
        double sum = 0.0;
        long count = 0L;
        double c = 0.0;
        for (int i = 0; i < this.workerCount; ++i) {
            double x = this.sum[i * 9] + this.sum[i * 9 + 1];
            double t = sum + x;
            c = Math.abs(sum) >= x ? (c += sum - t + x) : (c += x - t + sum);
            sum = t;
            count += this.count[i * 8];
        }
        this.transientSum = sum;
        this.transientCount = count;
        this.transientC = c;
    }
}

