/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.window;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.RecordSink;
import io.questdb.cairo.Reopenable;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.VirtualRecord;
import io.questdb.cairo.sql.WindowSPI;
import io.questdb.cairo.vm.api.MemoryARW;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.window.AbstractWindowFunctionFactory;
import io.questdb.griffin.engine.functions.window.LagLongFunctionFactory;
import io.questdb.griffin.engine.functions.window.LeadLagWindowFunctionFactoryHelper;
import io.questdb.griffin.engine.functions.window.WindowDateFunction;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class LeadDateFunctionFactory
extends AbstractWindowFunctionFactory {
    private static final String SIGNATURE = "lead(MV)";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        return LeadLagWindowFunctionFactoryHelper.newInstance(position, args, argPositions, configuration, sqlExecutionContext, defaultValue -> {
            if (!ColumnType.isAssignableFrom(defaultValue.getType(), 7)) {
                throw SqlException.$(argPositions.getQuick(2), "default value must be can cast to date");
            }
        }, LeadFunction::new, LagLongFunctionFactory.LeadLagValueCurrentRow::new, LeadOverPartitionFunction::new);
    }

    static class LeadOverPartitionFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLeadOverPartitionFunction
    implements WindowDateFunction {
        public LeadOverPartitionFunction(Map map, VirtualRecord partitionByRecord, RecordSink partitionBySink, MemoryARW memory, Function arg, boolean ignoreNulls, Function defaultValue, long offset) {
            super(map, partitionByRecord, partitionBySink, memory, arg, ignoreNulls, defaultValue, offset);
        }

        @Override
        protected boolean doPass1(long count, long offset, long startOffset, long firstIdx, Record record, long recordOffset, WindowSPI spi) {
            boolean respectNulls;
            long l = this.arg.getDate(record);
            long leadValue = count < offset ? (this.defaultValue == null ? Long.MIN_VALUE : this.defaultValue.getDate(record)) : this.memory.getLong(startOffset + firstIdx * 8L);
            boolean bl = respectNulls = !this.ignoreNulls || l != Long.MIN_VALUE;
            if (respectNulls) {
                this.memory.putLong(startOffset + firstIdx * 8L, l);
            }
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), leadValue);
            return respectNulls;
        }
    }

    static class LeadFunction
    extends LeadLagWindowFunctionFactoryHelper.BaseLeadFunction
    implements Reopenable,
    WindowDateFunction {
        public LeadFunction(Function arg, Function defaultValueFunc, long offset, MemoryARW memory, boolean ignoreNulls) {
            super(arg, defaultValueFunc, offset, memory, ignoreNulls);
        }

        @Override
        protected boolean doPass1(Record record, long recordOffset, WindowSPI spi) {
            boolean respectNull;
            long leadValue = this.count < this.offset ? (this.defaultValue == null ? Long.MIN_VALUE : this.defaultValue.getDate(record)) : this.buffer.getLong((long)this.loIdx * 8L);
            long l = this.arg.getDate(record);
            boolean bl = respectNull = !this.ignoreNulls || l != Long.MIN_VALUE;
            if (respectNull) {
                this.buffer.putLong((long)this.loIdx * 8L, l);
            }
            Unsafe.getUnsafe().putLong(spi.getAddress(recordOffset, this.columnIndex), leadValue);
            return respectNull;
        }
    }
}

