/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.test;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.SymbolTableSource;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.BooleanFunction;
import io.questdb.griffin.engine.functions.constants.BooleanConstant;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class TestNPEFactory
implements FunctionFactory {
    public static final String SIGNATURE = "npe()";

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        if (configuration.isDevModeEnabled()) {
            return NPEFunction.INSTANCE;
        }
        return BooleanConstant.FALSE;
    }

    private static class NPEFunction
    extends BooleanFunction {
        private static final NPEFunction INSTANCE = new NPEFunction();

        private NPEFunction() {
        }

        @Override
        public boolean getBool(Record rec) {
            throw new NullPointerException();
        }

        @Override
        public void init(SymbolTableSource symbolTableSource, SqlExecutionContext executionContext) throws SqlException {
            executionContext.getSecurityContext().authorizeSystemAdmin();
            super.init(symbolTableSource, executionContext);
        }

        @Override
        public boolean isThreadSafe() {
            return true;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(TestNPEFactory.SIGNATURE);
        }
    }
}

