/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.BinaryFunction;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class VwapDoubleGroupByFunction
extends DoubleFunction
implements GroupByFunction,
BinaryFunction {
    private final Function priceFunction;
    private final Function volumeFunction;
    private int valueIndex;

    public VwapDoubleGroupByFunction(@NotNull Function arg0, @NotNull Function arg1) {
        this.priceFunction = arg0;
        this.volumeFunction = arg1;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        double price = this.priceFunction.getDouble(record);
        double volume = this.volumeFunction.getDouble(record);
        if (Numbers.isFinite(price) && Numbers.isFinite(volume) && volume > 0.0) {
            double notional = price * volume;
            double vwap = notional / volume;
            mapValue.putDouble(this.valueIndex, vwap);
            mapValue.putDouble(this.valueIndex + 1, notional);
            mapValue.putDouble(this.valueIndex + 2, volume);
        } else {
            mapValue.putDouble(this.valueIndex, Double.NaN);
            mapValue.putDouble(this.valueIndex + 1, 0.0);
            mapValue.putDouble(this.valueIndex + 2, 0.0);
        }
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        double price = this.priceFunction.getDouble(record);
        double volume = this.volumeFunction.getDouble(record);
        if (Numbers.isFinite(price) && Numbers.isFinite(volume) && volume > 0.0) {
            double notional = price * volume;
            mapValue.addDouble(this.valueIndex + 1, notional);
            mapValue.addDouble(this.valueIndex + 2, volume);
            mapValue.putDouble(this.valueIndex, mapValue.getDouble(this.valueIndex + 1) / mapValue.getDouble(this.valueIndex + 2));
        }
    }

    @Override
    public double getDouble(Record rec) {
        return rec.getDouble(this.valueIndex);
    }

    @Override
    public Function getLeft() {
        return this.priceFunction;
    }

    @Override
    public String getName() {
        return "vwap";
    }

    @Override
    public Function getRight() {
        return this.volumeFunction;
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(10);
        columnTypes.add(10);
        columnTypes.add(10);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return BinaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        double srcNotional = srcValue.getDouble(this.valueIndex + 1);
        double srcVolume = srcValue.getDouble(this.valueIndex + 2);
        if (Numbers.isFinite(srcNotional) && Numbers.isFinite(srcVolume) && srcVolume > 0.0) {
            destValue.addDouble(this.valueIndex + 1, srcNotional);
            destValue.addDouble(this.valueIndex + 2, srcVolume);
            destValue.putDouble(this.valueIndex, destValue.getDouble(this.valueIndex + 1) / destValue.getDouble(this.valueIndex + 2));
        }
    }

    @Override
    public void setDouble(MapValue mapValue, double value) {
        mapValue.putDouble(this.valueIndex, value);
        mapValue.putDouble(this.valueIndex + 1, value);
        mapValue.putDouble(this.valueIndex + 2, 1.0);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putDouble(this.valueIndex, Double.NaN);
        mapValue.putDouble(this.valueIndex + 1, 0.0);
        mapValue.putDouble(this.valueIndex + 2, 0.0);
    }

    @Override
    public boolean supportsParallelism() {
        return BinaryFunction.super.supportsParallelism();
    }
}

