/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.groupby;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.GroupByFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.std.Numbers;
import org.jetbrains.annotations.NotNull;

public class MinFloatGroupByFunction
extends FloatFunction
implements GroupByFunction,
UnaryFunction {
    private final Function arg;
    private int valueIndex;

    public MinFloatGroupByFunction(@NotNull Function arg) {
        this.arg = arg;
    }

    @Override
    public void computeFirst(MapValue mapValue, Record record, long rowId) {
        mapValue.putFloat(this.valueIndex, this.arg.getFloat(record));
    }

    @Override
    public void computeNext(MapValue mapValue, Record record, long rowId) {
        float min = mapValue.getFloat(this.valueIndex);
        float next = this.arg.getFloat(record);
        if (next < min || Numbers.isNull(min)) {
            mapValue.putFloat(this.valueIndex, next);
        }
    }

    @Override
    public Function getArg() {
        return this.arg;
    }

    @Override
    public float getFloat(Record rec) {
        return rec.getFloat(this.valueIndex);
    }

    @Override
    public String getName() {
        return "min";
    }

    @Override
    public int getSampleByFlags() {
        return 31;
    }

    @Override
    public int getValueIndex() {
        return this.valueIndex;
    }

    @Override
    public void initValueIndex(int valueIndex) {
        this.valueIndex = valueIndex;
    }

    @Override
    public void initValueTypes(ArrayColumnTypes columnTypes) {
        this.valueIndex = columnTypes.getColumnCount();
        columnTypes.add(9);
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isThreadSafe() {
        return UnaryFunction.super.isThreadSafe();
    }

    @Override
    public void merge(MapValue destValue, MapValue srcValue) {
        float destMin;
        float srcMin = srcValue.getFloat(this.valueIndex);
        if (srcMin < (destMin = destValue.getFloat(this.valueIndex)) || Numbers.isNull(destMin)) {
            destValue.putFloat(this.valueIndex, srcMin);
        }
    }

    @Override
    public void setFloat(MapValue mapValue, float value) {
        mapValue.putFloat(this.valueIndex, value);
    }

    @Override
    public void setNull(MapValue mapValue) {
        mapValue.putFloat(this.valueIndex, Float.NaN);
    }

    @Override
    public boolean supportsParallelism() {
        return UnaryFunction.super.supportsParallelism();
    }
}

