/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.finance;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.DoubleFunction;
import io.questdb.griffin.engine.functions.QuaternaryFunction;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;

public class WeightedMidPriceFunctionFactory
implements FunctionFactory {
    @Override
    public String getSignature() {
        return "wmid(DDDD)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new WeightedMidPriceFunction(args.getQuick(0), args.getQuick(1), args.getQuick(2), args.getQuick(3));
    }

    private static class WeightedMidPriceFunction
    extends DoubleFunction
    implements QuaternaryFunction {
        private final Function askPrice;
        private final Function askSize;
        private final Function bidPrice;
        private final Function bidSize;

        public WeightedMidPriceFunction(Function bidSize, Function bidPrice, Function askPrice, Function askSize) {
            this.bidSize = bidSize;
            this.bidPrice = bidPrice;
            this.askPrice = askPrice;
            this.askSize = askSize;
        }

        @Override
        public double getDouble(Record rec) {
            double bs = this.bidSize.getDouble(rec);
            double bp = this.bidPrice.getDouble(rec);
            double ap = this.askPrice.getDouble(rec);
            double as = this.askSize.getDouble(rec);
            if (Numbers.isNull(bp) || Numbers.isNull(bs) || Numbers.isNull(ap) || Numbers.isNull(as)) {
                return Double.NaN;
            }
            double imbalance = bs / (bs + as);
            return ap * imbalance + bp * (1.0 - imbalance);
        }

        @Override
        public Function getFunc0() {
            return this.bidSize;
        }

        @Override
        public Function getFunc1() {
            return this.bidPrice;
        }

        @Override
        public Function getFunc2() {
            return this.askPrice;
        }

        @Override
        public Function getFunc3() {
            return this.askSize;
        }

        @Override
        public String getName() {
            return "wmid";
        }
    }
}

