/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.constants;

import io.questdb.cairo.sql.Record;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.FloatFunction;
import io.questdb.griffin.engine.functions.constants.ConstantFunction;
import io.questdb.std.Numbers;

public class FloatConstant
extends FloatFunction
implements ConstantFunction {
    public static final FloatConstant NULL = new FloatConstant(Float.NaN);
    private final float value;

    public FloatConstant(float value) {
        this.value = value;
    }

    public static FloatConstant newInstance(float value) {
        return Numbers.isFinite(value) ? new FloatConstant(value) : NULL;
    }

    @Override
    public float getFloat(Record rec) {
        return this.value;
    }

    @Override
    public boolean isNullConstant() {
        return Numbers.isNull(this.value);
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.val((double)this.value).val('f');
    }
}

