/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cutlass.pgwire.PGOids;

class PgTypeCatalogueCursor
implements NoRandomAccessRecordCursor {
    static final RecordMetadata METADATA;
    private static final int rowCount;
    public final int[] intValues = new int[METADATA.getColumnCount()];
    private final PgTypeCatalogueRecord record = new PgTypeCatalogueRecord();
    private int row = -1;

    public PgTypeCatalogueCursor() {
        this.intValues[4] = 11;
    }

    @Override
    public void close() {
        this.row = -1;
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        if (++this.row < rowCount) {
            int pgOid = PGOids.PG_TYPE_OIDS.get(this.row);
            int arrayOid = PGOids.pgToArrayOid(pgOid);
            int elemOid = PGOids.pgArrayToElementType(pgOid);
            this.intValues[0] = pgOid;
            this.intValues[3] = arrayOid;
            this.intValues[9] = Integer.MIN_VALUE;
            this.intValues[10] = elemOid;
            this.intValues[11] = 0;
            this.intValues[12] = 0;
            this.intValues[13] = 0;
            this.intValues[21] = 0;
            this.intValues[22] = 0;
            return true;
        }
        return false;
    }

    @Override
    public long preComputedStateSize() {
        return 0L;
    }

    @Override
    public long size() {
        return rowCount;
    }

    @Override
    public void toTop() {
        this.row = -1;
    }

    static {
        rowCount = PGOids.PG_TYPE_OIDS.size();
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("oid", 5));
        metadata.add(new TableColumnMetadata("typname", 11));
        metadata.add(new TableColumnMetadata("typbasetype", 5));
        metadata.add(new TableColumnMetadata("typarray", 5));
        metadata.add(new TableColumnMetadata("typnamespace", 5));
        metadata.add(new TableColumnMetadata("typnotnull", 1));
        metadata.add(new TableColumnMetadata("typtypmod", 5));
        metadata.add(new TableColumnMetadata("typtype", 4));
        metadata.add(new TableColumnMetadata("typcategory", 4));
        metadata.add(new TableColumnMetadata("typrelid", 5));
        metadata.add(new TableColumnMetadata("typelem", 5));
        metadata.add(new TableColumnMetadata("typreceive", 5));
        metadata.add(new TableColumnMetadata("typdelim", 5));
        metadata.add(new TableColumnMetadata("typinput", 5));
        metadata.add(new TableColumnMetadata("typowner", 5));
        metadata.add(new TableColumnMetadata("typlen", 3));
        metadata.add(new TableColumnMetadata("typbyval", 1));
        metadata.add(new TableColumnMetadata("typispreferred", 1));
        metadata.add(new TableColumnMetadata("typisdefined", 1));
        metadata.add(new TableColumnMetadata("typalign", 4));
        metadata.add(new TableColumnMetadata("typstorage", 4));
        metadata.add(new TableColumnMetadata("typndims", 5));
        metadata.add(new TableColumnMetadata("typcollation", 5));
        metadata.add(new TableColumnMetadata("typdefault", 11));
        METADATA = metadata;
    }

    class PgTypeCatalogueRecord
    implements Record {
        PgTypeCatalogueRecord() {
        }

        @Override
        public boolean getBool(int col) {
            return col == 18;
        }

        @Override
        public char getChar(int col) {
            if (col == 8) {
                return PGOids.PG_TYPE_TO_CATEGORY[PgTypeCatalogueCursor.this.row];
            }
            if (col == 19) {
                return 'c';
            }
            if (col == 20) {
                return 'p';
            }
            return 'b';
        }

        @Override
        public int getInt(int col) {
            return PgTypeCatalogueCursor.this.intValues[col];
        }

        @Override
        public short getShort(int col) {
            if (col == 15) {
                return PGOids.PG_TYPE_TO_LENGTH[PgTypeCatalogueCursor.this.row];
            }
            return -1;
        }

        @Override
        public CharSequence getStrA(int col) {
            if (col == 1) {
                return PGOids.PG_TYPE_TO_NAME[PgTypeCatalogueCursor.this.row];
            }
            if (col == 23) {
                return PGOids.PG_TYPE_TO_DEFAULT[PgTypeCatalogueCursor.this.row];
            }
            return null;
        }

        @Override
        public CharSequence getStrB(int col) {
            return this.getStrA(col);
        }

        @Override
        public int getStrLen(int col) {
            return TableUtils.lengthOf(this.getStrA(col));
        }
    }
}

