/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin;

import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlKeywords;
import io.questdb.griffin.model.AliasTranslator;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import java.util.ArrayDeque;

public final class WhereClauseSymbolEstimator
implements Mutable {
    private static final int OP_EQUAL = 1;
    private static final int OP_IN = 2;
    private static final int OP_NOT = 3;
    private static final int OP_NOT_EQ = 4;
    private static final CharSequenceIntHashMap ops = new CharSequenceIntHashMap();
    private final IntIntHashMap columnIndexesToListIndexes = new IntIntHashMap();
    private final ArrayDeque<ExpressionNode> stack = new ArrayDeque();
    private boolean gaveUp;
    private IntList symbolCounts;

    @Override
    public void clear() {
        this.stack.clear();
        this.columnIndexesToListIndexes.clear();
        this.symbolCounts = null;
        this.gaveUp = false;
    }

    public IntList estimate(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata, IntList columnIndexes) throws SqlException {
        int i;
        if (node == null) {
            return null;
        }
        this.clear();
        int n = columnIndexes.size();
        for (i = 0; i < n; ++i) {
            this.columnIndexesToListIndexes.put(columnIndexes.getQuick(i), i);
        }
        this.symbolCounts = new IntList(columnIndexes.size());
        this.symbolCounts.setAll(columnIndexes.size(), 0);
        if (!this.analyze(translator, node, metadata)) {
            while (!this.stack.isEmpty() || node != null) {
                if (node != null) {
                    if (SqlKeywords.isAndKeyword(node.token)) {
                        if (!this.analyze(translator, node.rhs, metadata)) {
                            this.stack.push(node.rhs);
                        }
                        if (this.gaveUp) break;
                        ExpressionNode expressionNode = node = this.analyze(translator, node.lhs, metadata) ? null : node.lhs;
                        if (!this.gaveUp) continue;
                        break;
                    }
                    if (SqlKeywords.isOrKeyword(node.token)) {
                        this.giveUp();
                        break;
                    }
                    node = this.stack.poll();
                    continue;
                }
                node = this.stack.poll();
            }
        }
        n = this.symbolCounts.size();
        for (i = 0; i < n; ++i) {
            if (this.symbolCounts.getQuick(i) != 0) continue;
            this.symbolCounts.setQuick(i, Integer.MAX_VALUE);
        }
        return this.symbolCounts;
    }

    private boolean analyze(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        switch (ops.get(node.token)) {
            case 2: {
                this.analyzeIn(translator, node, metadata);
                return true;
            }
            case 1: {
                this.analyzeEquals(translator, node, metadata);
                return true;
            }
            case 4: {
                this.analyzeNotEquals(translator, node, metadata);
                return true;
            }
            case 3: {
                if (SqlKeywords.isInKeyword(node.rhs.token)) {
                    this.analyzeNotIn(translator, node.rhs, metadata);
                } else {
                    this.giveUp();
                }
                return true;
            }
        }
        return false;
    }

    private void analyzeEquals(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        this.estimateEquals0(translator, node.lhs, node.rhs, metadata);
        this.estimateEquals0(translator, node.rhs, node.lhs, metadata);
    }

    private void analyzeIn(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        ExpressionNode col;
        if (node.paramCount < 2) {
            return;
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 7) {
            return;
        }
        CharSequence column = translator.translateAlias(col.token);
        int columnIndex = metadata.getColumnIndexQuiet(column);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(node.position, node.token);
        }
        int keyIndex = this.columnIndexesToListIndexes.keyIndex(columnIndex);
        if (keyIndex > -1) {
            return;
        }
        if (node.rhs != null && node.rhs.type == 10) {
            this.giveUp();
            return;
        }
        int listIndex = this.columnIndexesToListIndexes.valueAt(keyIndex);
        this.symbolCounts.increment(listIndex, node.paramCount - 1);
    }

    private void analyzeNotEquals(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        this.estimateNotEquals0(translator, node.lhs, metadata);
        this.estimateNotEquals0(translator, node.rhs, metadata);
    }

    private void analyzeNotIn(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        ExpressionNode col;
        if (node.paramCount < 2) {
            return;
        }
        ExpressionNode expressionNode = col = node.paramCount < 3 ? node.lhs : node.args.getLast();
        if (col.type != 7) {
            return;
        }
        CharSequence column = translator.translateAlias(col.token);
        int columnIndex = metadata.getColumnIndexQuiet(column);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(node.position, node.token);
        }
        int keyIndex = this.columnIndexesToListIndexes.keyIndex(columnIndex);
        if (keyIndex > -1) {
            return;
        }
        this.giveUp();
    }

    private void estimateEquals0(AliasTranslator translator, ExpressionNode a, ExpressionNode b, RecordMetadata metadata) throws SqlException {
        if (a == null || a.type != 7) {
            return;
        }
        CharSequence column = translator.translateAlias(a.token);
        int columnIndex = metadata.getColumnIndexQuiet(column);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(a.position, a.token);
        }
        int keyIndex = this.columnIndexesToListIndexes.keyIndex(columnIndex);
        if (keyIndex > -1) {
            return;
        }
        if (b.type != 4 && b.type != 3) {
            this.giveUp();
            return;
        }
        int listIndex = this.columnIndexesToListIndexes.valueAt(keyIndex);
        this.symbolCounts.increment(listIndex);
    }

    private void estimateNotEquals0(AliasTranslator translator, ExpressionNode node, RecordMetadata metadata) throws SqlException {
        if (node == null || node.type != 7) {
            return;
        }
        CharSequence column = translator.translateAlias(node.token);
        int columnIndex = metadata.getColumnIndexQuiet(column);
        if (columnIndex == -1) {
            throw SqlException.invalidColumn(node.position, node.token);
        }
        int keyIndex = this.columnIndexesToListIndexes.keyIndex(columnIndex);
        if (keyIndex > -1) {
            return;
        }
        this.giveUp();
    }

    private void giveUp() {
        this.gaveUp = true;
        this.symbolCounts.setAll(this.symbolCounts.size(), Integer.MAX_VALUE);
    }

    static {
        ops.put("=", 1);
        ops.put("in", 2);
        ops.put("not", 3);
        ops.put("!=", 4);
    }
}

