/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cutlass.http.client;

import io.questdb.HttpClientConfiguration;
import io.questdb.cutlass.http.client.HttpClient;
import io.questdb.cutlass.http.client.HttpClientException;
import io.questdb.network.Epoll;
import io.questdb.network.EpollAccessor;
import io.questdb.network.SocketFactory;
import io.questdb.std.Misc;

public class HttpClientLinux
extends HttpClient {
    private Epoll epoll;

    public HttpClientLinux(HttpClientConfiguration configuration, SocketFactory socketFactory) {
        super(configuration, socketFactory);
        this.epoll = new Epoll(configuration.getEpollFacade(), configuration.getWaitQueueCapacity());
    }

    @Override
    public void close() {
        super.close();
        this.epoll = Misc.free(this.epoll);
    }

    @Override
    protected void ioWait(int timeout, int op) {
        int event;
        int n = event = op == 4 ? EpollAccessor.EPOLLOUT : EpollAccessor.EPOLLIN;
        if (this.epoll.control(this.socket.getFd(), 0L, EpollAccessor.EPOLL_CTL_MOD, event) < 0) {
            throw new HttpClientException("internal error: epoll_ctl failure [op=").put(op).put(", errno=").put(this.nf.errno()).put(']');
        }
        this.dieWaiting(this.epoll.poll(timeout));
    }

    @Override
    protected void setupIoWait() {
        if (this.epoll.control(this.socket.getFd(), 0L, EpollAccessor.EPOLL_CTL_ADD, EpollAccessor.EPOLLOUT) < 0) {
            throw new HttpClientException("internal error: epoll_ctl failure [cmd=add, errno=").put(this.nf.errno()).put(']');
        }
    }
}

