/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.wal.WalDirectoryPolicy;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.SimpleWaitingLock;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntIntHashMap;
import io.questdb.std.LongList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjHashSet;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.DirectUtf8StringZ;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import java.io.Closeable;

public class WalPurgeJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(WalPurgeJob.class);
    private final TableSequencerAPI.TableSequencerCallback broadSweepRef;
    private final long checkInterval;
    private final ObjList<TableToken> childViewSink = new ObjList();
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final Logic logic;
    private final MillisecondClock millisecondClock;
    private final IntHashSet onDiskWalIDSet = new IntHashSet();
    private final Path path = new Path();
    private final SimpleWaitingLock runLock = new SimpleWaitingLock();
    private final long spinLockTimeout;
    private final ObjHashSet<TableToken> tableTokenBucket = new ObjHashSet();
    private final TxReader txReader;
    private final WalDirectoryPolicy walDirectoryPolicy;
    private final DirectUtf8StringZ walName = new DirectUtf8StringZ();
    private long last = 0L;
    private TableToken tableToken;

    public WalPurgeJob(CairoEngine engine, FilesFacade ff, MicrosecondClock clock) {
        this.engine = engine;
        this.ff = ff;
        this.clock = clock;
        this.checkInterval = engine.getConfiguration().getWalPurgeInterval() * 1000L;
        this.millisecondClock = engine.getConfiguration().getMillisecondClock();
        this.spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
        this.txReader = new TxReader(ff);
        this.broadSweepRef = this::broadSweep;
        this.walDirectoryPolicy = engine.getWalDirectoryPolicy();
        assert ("wal".equals("wal"));
        this.configuration = engine.getConfiguration();
        this.logic = new Logic(new FsDeleter(), engine.getConfiguration().getWalPurgeWaitBeforeDelete());
    }

    public WalPurgeJob(CairoEngine engine) {
        this(engine, engine.getConfiguration().getFilesFacade(), engine.getConfiguration().getMicrosecondClock());
    }

    @Override
    public void close() {
        this.txReader.close();
        this.path.close();
    }

    public void delayByHalfInterval() {
        this.last = this.clock.getTicks() - this.checkInterval / 2L;
    }

    public SimpleWaitingLock getRunLock() {
        return this.runLock;
    }

    private static boolean matchesNumberPattern(Utf8Sequence name) {
        int n = name.size();
        for (int i = 0; i < n; ++i) {
            byte b = name.byteAt(i);
            if (b >= 48 && b <= 57) continue;
            return false;
        }
        return true;
    }

    private static boolean matchesWalNamePattern(Utf8Sequence name) {
        int len = name.size();
        if (len < "wal".length() + 1) {
            return false;
        }
        if (name.byteAt(0) != 119 || name.byteAt(1) != 97 || name.byteAt(2) != 108) {
            return false;
        }
        for (int i = 3; i < len; ++i) {
            byte b = name.byteAt(i);
            if (b >= 48 && b <= 57) continue;
            return false;
        }
        return true;
    }

    private void broadSweep() {
        this.engine.getTableSequencerAPI().forAllWalTables(this.tableTokenBucket, true, this.broadSweepRef);
    }

    private void broadSweep(int tableId, TableToken tableToken, long lastTxn) {
        try {
            this.tableToken = tableToken;
            this.logic.reset(tableToken);
            this.onDiskWalIDSet.clear();
            boolean tableDropped = false;
            this.discoverWalSegments();
            this.discoverSequencerParts();
            if (this.logic.hasOnDiskSegments()) {
                try {
                    tableDropped = this.fetchSequencerPairs();
                }
                catch (Throwable th) {
                    this.logic.releaseLocks();
                    throw th;
                }
                this.logic.run();
            }
            if (tableDropped || lastTxn < 0L && this.engine.isTableDropped(tableToken)) {
                if (this.logic.hasPendingTasks()) {
                    LOG.info().$("table is dropped, but has WALs containing segments with pending tasks [table=").$(tableToken).I$();
                } else if (TableUtils.exists(this.ff, Path.getThreadLocal(""), (CharSequence)this.configuration.getDbRoot(), tableToken.getDirName()) != 0) {
                    Path pathToDelete = Path.getThreadLocal(this.configuration.getDbRoot()).concat(tableToken);
                    Path symLinkTarget = null;
                    if (this.ff.isSoftLink(this.path.$()) && !this.ff.readLink(pathToDelete, symLinkTarget = Path.getThreadLocal2(""))) {
                        symLinkTarget = null;
                    }
                    boolean fullyDeleted = this.ff.rmdir(pathToDelete, false);
                    if (symLinkTarget != null) {
                        this.ff.rmdir(symLinkTarget, false);
                    }
                    if (fullyDeleted) {
                        this.engine.removeTableToken(tableToken);
                        LOG.info().$("table is fully dropped [tableDir=").$(pathToDelete).I$();
                        TableUtils.lockName(pathToDelete);
                        this.ff.removeQuiet(pathToDelete.$());
                    } else {
                        LOG.info().$("could not fully remove table, some files left on the disk [tableDir=").$(pathToDelete).I$();
                    }
                } else {
                    LOG.info().$("table is not fully dropped, pinging WAL Apply job to delete table files [table=").$(tableToken).I$();
                    this.engine.notifyWalTxnCommitted(tableToken);
                }
            }
        }
        catch (CairoException ce) {
            LOG.error().$("broad sweep failed [table=").$(tableToken).$(", msg=").$(ce).$(", errno=").$(this.ff.errno()).I$();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverSequencerParts() {
        long p;
        LPSZ path = this.setSeqPartPath(this.tableToken).$();
        if (this.ff.exists(path) && (p = this.ff.findFirst(path)) > 0L) {
            try {
                do {
                    int type = this.ff.findType(p);
                    long pUtf8NameZ = this.ff.findName(p);
                    if (type != 8 || !WalPurgeJob.matchesNumberPattern(this.walName.of(pUtf8NameZ))) continue;
                    try {
                        int partNo = Numbers.parseInt(this.walName);
                        this.logic.trackSeqPart(partNo);
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                } while (this.ff.findNext(p) > 0);
            }
            finally {
                this.ff.findClose(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discoverWalSegments() {
        Path path = this.setTablePath(this.tableToken);
        long p = this.ff.findFirst(path.$());
        int rootPathLen = path.size();
        this.logic.sequencerHasPendingTasks(this.sequencerHasPendingTasks());
        if (p > 0L) {
            try {
                do {
                    int type = this.ff.findType(p);
                    long pUtf8NameZ = this.ff.findName(p);
                    if (type != 4 || !WalPurgeJob.matchesWalNamePattern(this.walName.of(pUtf8NameZ))) continue;
                    try {
                        int walId = Numbers.parseInt(this.walName, 3, this.walName.size());
                        this.onDiskWalIDSet.add(walId);
                        long walLockFd = TableUtils.lock(this.ff, this.setWalLockPath(this.tableToken, walId).$(), false);
                        boolean walHasPendingTasks = false;
                        path.trimTo(rootPathLen).concat(pUtf8NameZ);
                        int walPathLen = path.size();
                        long sp = this.ff.findFirst(path.$());
                        if (sp > 0L) {
                            try {
                                do {
                                    type = this.ff.findType(sp);
                                    pUtf8NameZ = this.ff.findName(sp);
                                    if (type != 4 || !WalPurgeJob.matchesNumberPattern(this.walName.of(pUtf8NameZ))) continue;
                                    try {
                                        boolean pendingTasks;
                                        int segmentId = Numbers.parseInt(this.walName);
                                        if (segmentId < 0 || segmentId > 0x1FFFFFFE) {
                                            throw NumericException.INSTANCE;
                                        }
                                        path.trimTo(walPathLen);
                                        Path segmentPath = this.setSegmentLockPath(this.tableToken, walId, segmentId);
                                        long lockFd = TableUtils.lock(this.ff, segmentPath.$(), false);
                                        if (lockFd > -1L && (pendingTasks = this.segmentHasPendingTasks(walId, segmentId))) {
                                            this.ff.close(lockFd);
                                            lockFd = -1L;
                                        }
                                        walHasPendingTasks |= lockFd < 0L;
                                        this.logic.trackDiscoveredSegment(walId, segmentId, lockFd);
                                    }
                                    catch (NumericException numericException) {
                                        // empty catch block
                                    }
                                } while (this.ff.findNext(sp) > 0);
                            }
                            finally {
                                this.ff.findClose(sp);
                            }
                        }
                        if (walLockFd > -1L && walHasPendingTasks) {
                            this.ff.close(walLockFd);
                            walLockFd = -1L;
                        }
                        this.logic.trackDiscoveredWal(walId, walLockFd);
                    }
                    catch (NumericException numericException) {
                        // empty catch block
                    }
                } while (this.ff.findNext(p) > 0);
            }
            finally {
                this.ff.findClose(p);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchSequencerPairs() {
        this.setTxnPath(this.tableToken);
        if (!this.engine.isTableDropped(this.tableToken)) {
            try {
                this.txReader.ofRO(this.path.$(), 3);
                TableUtils.safeReadTxn(this.txReader, this.millisecondClock, this.spinLockTimeout);
            }
            catch (CairoException ex) {
                if (this.engine.isTableDropped(this.tableToken)) {
                    boolean bl = false;
                    this.txReader.close();
                    return bl;
                }
                throw ex;
            }
            long safeToPurgeTxn = this.getSafeToPurgeUpToTxn(this.txReader.getSeqTxn());
            TableSequencerAPI tableSequencerAPI = this.engine.getTableSequencerAPI();
            try (TransactionLogCursor transactionLogCursor = tableSequencerAPI.getCursor(this.tableToken, safeToPurgeTxn);){
                int txnPartSize = transactionLogCursor.getPartitionSize();
                long currentSeqPart = this.getCurrentSeqPart(safeToPurgeTxn, txnPartSize);
                this.logic.trackCurrentSeqPart(currentSeqPart);
                while (this.onDiskWalIDSet.size() > 0 && transactionLogCursor.hasNext()) {
                    int walId = transactionLogCursor.getWalId();
                    if (this.onDiskWalIDSet.remove(walId) == -1) continue;
                    int segmentId = transactionLogCursor.getSegmentId();
                    this.logic.trackNextToApplySegment(walId, segmentId);
                }
            }
            catch (CairoException e) {
                if (e.isTableDropped()) {
                    boolean bl = true;
                    this.txReader.close();
                    return bl;
                }
                throw e;
            }
            finally {
                this.txReader.close();
            }
        }
        return false;
    }

    private long getSafeToPurgeUpToTxn(long readerSeqTxn) {
        long safeToPurgeTxn = readerSeqTxn;
        this.childViewSink.clear();
        this.engine.getMatViewGraph().getDependentViews(this.tableToken, this.childViewSink);
        int n = this.childViewSink.size();
        for (int v = 0; v < n; ++v) {
            long appliedToViewTxn;
            boolean invalid;
            TableToken viewToken = this.childViewSink.get(v);
            MatViewState state = this.engine.getMatViewStateStore().getViewState(viewToken);
            if (state == null || state.isDropped()) continue;
            boolean bl = invalid = state.isPendingInvalidation() || state.isInvalid();
            if (state.isLocked() && (state.getLastRefreshBaseTxn() == -1L || invalid)) {
                return 0L;
            }
            if (invalid || (appliedToViewTxn = Math.max(state.getLastRefreshBaseTxn(), state.getRefreshIntervalsBaseTxn())) <= -1L) continue;
            safeToPurgeTxn = Math.min(safeToPurgeTxn, appliedToViewTxn);
        }
        return safeToPurgeTxn;
    }

    private boolean recursiveDelete(Path path) {
        if (!this.ff.rmdir(path, false) && !Files.errnoFileDoesNotExist(this.ff.errno())) {
            LOG.debug().$("could not delete directory [path=").$(path).$(", errno=").$(this.ff.errno()).I$();
            return false;
        }
        return true;
    }

    private boolean segmentHasPendingTasks(int walId, int segmentId) {
        return this.walDirectoryPolicy.isInUse(this.setSegmentPath(this.tableToken, walId, segmentId));
    }

    private boolean sequencerHasPendingTasks() {
        return this.walDirectoryPolicy.isInUse(this.path.of(this.configuration.getDbRoot()).concat(this.tableToken).concat("txn_seq"));
    }

    private Path setSegmentLockPath(TableToken tableName, int walId, int segmentId) {
        TableUtils.lockName(this.setSegmentPath(tableName, walId, segmentId));
        return this.path;
    }

    private Path setSegmentPath(TableToken tableName, int walId, int segmentId) {
        return this.path.of(this.configuration.getDbRoot()).concat(tableName).concat("wal").put(walId).slash().put(segmentId);
    }

    private Path setSeqPartPath(TableToken tableName) {
        return this.path.of(this.configuration.getDbRoot()).concat(tableName).concat("txn_seq").concat("_txn_parts");
    }

    private Path setTablePath(TableToken tableName) {
        return this.path.of(this.configuration.getDbRoot()).concat(tableName);
    }

    private void setTxnPath(TableToken tableName) {
        this.path.of(this.configuration.getDbRoot()).concat(tableName).concat("_txn");
    }

    private Path setWalLockPath(TableToken tableName, int walId) {
        this.path.of(this.configuration.getDbRoot()).concat(tableName).concat("wal").put(walId);
        TableUtils.lockName(this.path);
        return this.path;
    }

    private Path setWalPath(TableToken tableName, int walId) {
        return this.path.of(this.configuration.getDbRoot()).concat(tableName).concat("wal").put(walId);
    }

    protected long getCurrentSeqPart(long lastAppliedTxn, int txnPartSize) {
        if (txnPartSize > 0) {
            return (lastAppliedTxn - 1L) / (long)txnPartSize;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected boolean runSerially() {
        long t = this.clock.getTicks();
        if (this.last + this.checkInterval < t) {
            this.last = t;
            if (this.runLock.tryLock()) {
                try {
                    this.broadSweep();
                }
                finally {
                    this.runLock.unlock();
                }
            } else {
                LOG.info().$("skipping, locked out").$();
            }
        }
        return false;
    }

    public static class Logic {
        private final Deleter deleter;
        private final LongList discovered = new LongList();
        private final IntIntHashMap nextToApply = new IntIntHashMap();
        private final int waitBeforeDelete;
        private long currentSeqPart;
        private boolean logged;
        private boolean sequencerPending;
        private TableToken tableToken;

        public Logic(Deleter deleter, int waitBeforeDelete) {
            this.deleter = deleter;
            this.waitBeforeDelete = waitBeforeDelete;
        }

        public boolean hasOnDiskSegments() {
            return this.discovered.size() != 0;
        }

        public boolean hasPendingTasks() {
            if (this.sequencerPending) {
                return true;
            }
            for (int i = 0; i < this.getStateSize(); ++i) {
                if (this.getLockFd(i) >= 0L) continue;
                return true;
            }
            return false;
        }

        public void releaseLocks() {
            int n = this.getStateSize();
            for (int i = 0; i < n; ++i) {
                this.deleter.unlock(this.getLockFd(i));
            }
        }

        public void reset(TableToken tableToken) {
            this.tableToken = tableToken;
            this.nextToApply.clear();
            this.discovered.clear();
            this.sequencerPending = false;
            this.currentSeqPart = -1L;
            this.logged = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            i = 0;
            n = this.getStateSize();
            if (n > 0 && this.waitBeforeDelete > 0) {
                Os.sleep(this.waitBeforeDelete);
            }
            try {
                while (i < n) {
                    block12: {
                        block10: {
                            block11: {
                                lockFd = this.getLockFd(i);
                                walId = this.getWalId(i);
                                segmentId = this.getSegmentId(i);
                                nextToApplySegmentId = this.nextToApply.get(walId);
                                if (lockFd <= -1L) break block10;
                                if (!Logic.isWalDir(segmentId, walId)) break block11;
                                v0 = walAlreadyApplied = nextToApplySegmentId == -1;
                                if (!walAlreadyApplied) ** GOTO lbl-1000
                                this.logDebugInfo();
                                this.deleter.deleteWalDirectory(walId, lockFd);
                                break block12;
                            }
                            v1 = segmentAlreadyApplied = nextToApplySegmentId == -1 || nextToApplySegmentId > segmentId;
                            if (segmentAlreadyApplied) {
                                this.logDebugInfo();
                                this.deleter.deleteSegmentDirectory(walId, segmentId, lockFd);
                            } else lbl-1000:
                            // 2 sources

                            {
                                this.deleter.unlock(lockFd);
                            }
                            break block12;
                        }
                        seqPart = this.getSeqPart(walId, segmentId);
                        if (seqPart > -1 && (long)seqPart < this.currentSeqPart) {
                            this.logDebugInfo();
                            this.deleter.deleteSequencerPart(seqPart);
                        }
                    }
                    ++i;
                }
            }
            finally {
                while (i < n) {
                    this.deleter.unlock(this.getLockFd(i));
                    ++i;
                }
            }
        }

        public void sequencerHasPendingTasks(boolean isPending) {
            this.sequencerPending = isPending;
        }

        public void trackCurrentSeqPart(long partNo) {
            this.currentSeqPart = partNo;
        }

        public void trackDiscoveredSegment(int walId, int segmentId, long lockFd) {
            this.discovered.add(walId);
            this.discovered.add(segmentId);
            this.discovered.add(lockFd);
        }

        public void trackDiscoveredWal(int walId, long lockFd) {
            this.trackDiscoveredSegment(walId, 0x1FFFFFFF, lockFd);
        }

        public void trackNextToApplySegment(int walId, int segmentId) {
            int index = this.nextToApply.keyIndex(walId);
            if (index > -1) {
                this.nextToApply.putAt(index, walId, segmentId);
            }
        }

        public void trackSeqPart(int part) {
            this.discovered.add(-1L);
            this.discovered.add(part);
            this.discovered.add(-1L);
        }

        private static boolean isWalDir(int segmentId, int walId) {
            return segmentId == 0x1FFFFFFF && walId != -1;
        }

        private long getLockFd(int index) {
            return this.discovered.get(index * 3 + 2);
        }

        private int getSegmentId(int index) {
            return (int)this.discovered.get(index * 3 + 1);
        }

        private int getSeqPart(int walId, int segmentId) {
            return walId == -1 ? segmentId : -1;
        }

        private int getStateSize() {
            return this.discovered.size() / 3;
        }

        private int getWalId(int index) {
            return (int)this.discovered.get(index * 3);
        }

        private void logDebugInfo() {
            if (!this.logged) {
                this.printDebugState();
                this.logged = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printDebugState() {
            LogRecord log = LOG.info();
            try {
                log.$("table=").$(this.tableToken).$(", discovered=[");
                int n = this.getStateSize();
                for (int i = 0; i < n; ++i) {
                    int walId = this.getWalId(i);
                    int segmentId = this.getSegmentId(i);
                    long lockId = this.getLockFd(i);
                    int partNo = this.getSeqPart(walId, segmentId);
                    if (partNo > -1) {
                        log.$("seqPart=").$(partNo);
                        if ((long)partNo == this.currentSeqPart) {
                            log.$(":current");
                        }
                    } else {
                        if (Logic.isWalDir(segmentId, walId)) {
                            log.$("(wal").$(walId);
                        } else {
                            int nextToApplyId = this.nextToApply.get(walId);
                            log.$('(').$(walId).$(',').$(segmentId);
                            if (segmentId == nextToApplyId) {
                                log.$(":next");
                            }
                        }
                        if (lockId < 0L) {
                            log.$(":busy");
                        }
                        log.$(')');
                    }
                    if (i >= n - 1) continue;
                    log.$(',');
                }
            }
            finally {
                log.I$();
            }
        }
    }

    private class FsDeleter
    implements Deleter {
        private FsDeleter() {
        }

        @Override
        public void deleteSegmentDirectory(int walId, int segmentId, long lockFd) {
            LOG.debug().$("deleting WAL segment directory [table=").$(WalPurgeJob.this.tableToken).$(", walId=").$(walId).$(", segmentId=").$(segmentId).I$();
            if (WalPurgeJob.this.recursiveDelete(WalPurgeJob.this.setSegmentPath(WalPurgeJob.this.tableToken, walId, segmentId))) {
                WalPurgeJob.this.ff.closeRemove(lockFd, WalPurgeJob.this.setSegmentLockPath(WalPurgeJob.this.tableToken, walId, segmentId).$());
            } else {
                WalPurgeJob.this.ff.close(lockFd);
            }
        }

        @Override
        public void deleteSequencerPart(int seqPart) {
            LOG.debug().$("deleting sequencer part [table=").$(WalPurgeJob.this.tableToken).$(", part=").$(seqPart).I$();
            Path path = WalPurgeJob.this.setSeqPartPath(WalPurgeJob.this.tableToken).put(Files.SEPARATOR).put(seqPart);
            WalPurgeJob.this.ff.removeQuiet(path.$());
        }

        @Override
        public void deleteWalDirectory(int walId, long lockFd) {
            LOG.debug().$("deleting WAL directory [table=").$(WalPurgeJob.this.tableToken).$(", walId=").$(walId).I$();
            if (WalPurgeJob.this.recursiveDelete(WalPurgeJob.this.setWalPath(WalPurgeJob.this.tableToken, walId))) {
                WalPurgeJob.this.ff.closeRemove(lockFd, WalPurgeJob.this.setWalLockPath(WalPurgeJob.this.tableToken, walId).$());
            } else {
                WalPurgeJob.this.ff.close(lockFd);
            }
        }

        @Override
        public void unlock(long lockFd) {
            if (lockFd > -1L) {
                WalPurgeJob.this.ff.close(lockFd);
            }
        }
    }

    public static interface Deleter {
        public void deleteSegmentDirectory(int var1, int var2, long var3);

        public void deleteSequencerPart(int var1);

        public void deleteWalDirectory(int var1, long var2);

        public void unlock(long var1);
    }
}

