/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.griffin.ColumnConversionOffsetSink;
import io.questdb.std.LongList;

public class SegmentColumnRollSink
implements ColumnConversionOffsetSink {
    private final int ENTRIES_PER_COLUMN = 6;
    private final LongList data = new LongList();
    private int baseIndex = -6;

    public void clear() {
        this.data.clear();
        this.baseIndex = -6;
    }

    public int count() {
        return this.data.size() / 6;
    }

    public long getDestAuxFd(int columnIndex) {
        return this.data.get(columnIndex * 6 + 1);
    }

    public long getDestAuxSize(int columnIndex) {
        return this.data.get(columnIndex * 6 + 5);
    }

    public long getDestPrimaryFd(int columnIndex) {
        return this.data.get(columnIndex * 6);
    }

    public long getDestPrimarySize(int columnIndex) {
        return this.data.get(columnIndex * 6 + 4);
    }

    public long getSrcAuxOffset(int c) {
        return this.data.get(c * 6 + 3);
    }

    public long getSrcPrimaryOffset(int columnIndex) {
        return this.data.get(columnIndex * 6 + 2);
    }

    public void nextColumn() {
        this.baseIndex += 6;
        this.data.setPos(this.baseIndex + 6);
        this.data.fill(this.baseIndex, this.baseIndex + 6, -1L);
    }

    public void setDestPrimaryFd(long fd) {
        this.data.extendAndSet(this.baseIndex, fd);
    }

    public void setDestSecondaryFd(long fd) {
        this.data.extendAndSet(this.baseIndex + 1, fd);
    }

    @Override
    public void setDestSizes(long primarySize, long auxSize) {
        this.data.extendAndSet(this.baseIndex + 4, primarySize);
        this.data.extendAndSet(this.baseIndex + 5, auxSize);
    }

    @Override
    public void setSrcOffsets(long primaryOffset, long auxOffset) {
        this.data.extendAndSet(this.baseIndex + 2, primaryOffset);
        this.data.extendAndSet(this.baseIndex + 3, auxOffset);
    }
}

