/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.Telemetry;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoKeywords;
import io.questdb.cairo.EntryUnavailableException;
import io.questdb.cairo.ErrorTag;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.file.BlockFileWriter;
import io.questdb.cairo.mv.MatViewRefreshTask;
import io.questdb.cairo.mv.MatViewState;
import io.questdb.cairo.wal.OperationExecutor;
import io.questdb.cairo.wal.TableWriterPressureControl;
import io.questdb.cairo.wal.WalEventCursor;
import io.questdb.cairo.wal.WalEventReader;
import io.questdb.cairo.wal.WalMetrics;
import io.questdb.cairo.wal.WalTxnDetails;
import io.questdb.cairo.wal.seq.SeqTxnTracker;
import io.questdb.cairo.wal.seq.TableMetadataChange;
import io.questdb.cairo.wal.seq.TableMetadataChangeLog;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.griffin.SqlException;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.AbstractQueueConsumerJob;
import io.questdb.mp.Job;
import io.questdb.std.FilesFacade;
import io.questdb.std.LongList;
import io.questdb.std.Misc;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8s;
import io.questdb.tasks.TelemetryTask;
import io.questdb.tasks.TelemetryWalTask;
import io.questdb.tasks.WalTxnNotificationTask;
import java.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyWal2TableJob
extends AbstractQueueConsumerJob<WalTxnNotificationTask>
implements Closeable {
    public static final String WAL_2_TABLE_RESUME_REASON = "Resume WAL Data Application";
    private static final Log LOG = LogFactory.getLog(ApplyWal2TableJob.class);
    private static final String WAL_2_TABLE_WRITE_REASON = "WAL Data Application";
    private final CairoConfiguration config;
    private final CairoEngine engine;
    private final WalMetrics metrics;
    private final MicrosecondClock microClock;
    private final MatViewRefreshTask mvRefreshTask = new MatViewRefreshTask();
    private final BlockFileWriter mvStateWriter;
    private final OperationExecutor operationExecutor;
    private final long tableTimeQuotaMicros;
    private final Telemetry<TelemetryTask> telemetry;
    private final TelemetryFacade telemetryFacade;
    private final WalEventReader walEventReader;
    private final Telemetry<TelemetryWalTask> walTelemetry;
    private final WalTelemetryFacade walTelemetryFacade;
    private long lastAttemptSeqTxn;
    private long lastCommittedRows;

    public ApplyWal2TableJob(CairoEngine engine, int sharedQueryWorkerCount) {
        super(engine.getMessageBus().getWalTxnNotificationQueue(), engine.getMessageBus().getWalTxnNotificationSubSequence());
        this.engine = engine;
        this.walTelemetry = engine.getTelemetryWal();
        this.walTelemetryFacade = this.walTelemetry.isEnabled() ? this::doStoreWalTelemetry : this::storeWalTelemetryNoop;
        this.telemetry = engine.getTelemetry();
        this.telemetryFacade = this.telemetry.isEnabled() ? this::doStoreTelemetry : this::storeTelemetryNoOp;
        this.operationExecutor = new OperationExecutor(engine, sharedQueryWorkerCount);
        CairoConfiguration configuration = engine.getConfiguration();
        this.microClock = configuration.getMicrosecondClock();
        this.walEventReader = new WalEventReader(configuration.getFilesFacade());
        this.metrics = engine.getMetrics().walMetrics();
        this.tableTimeQuotaMicros = configuration.getWalApplyTableTimeQuota() >= 0L ? configuration.getWalApplyTableTimeQuota() * 1000L : 86400000000L;
        this.config = engine.getConfiguration();
        this.mvStateWriter = new BlockFileWriter(this.config.getFilesFacade(), this.config.getCommitMode());
    }

    @Override
    public void close() {
        Misc.free(this.operationExecutor);
        Misc.free(this.walEventReader);
        Misc.free(this.mvStateWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanDroppedTableDirectory(CairoEngine engine, Path tempPath, TableToken tableToken) {
        boolean allClean = true;
        FilesFacade ff = engine.getConfiguration().getFilesFacade();
        tempPath.of(engine.getConfiguration().getDbRoot()).concat(tableToken);
        int rootLen = tempPath.size();
        long p = ff.findFirst(tempPath.$());
        if (p > 0L) {
            try {
                do {
                    int type;
                    long pUtf8NameZ;
                    if (ff.isDirOrSoftLinkDirNoDots(tempPath, rootLen, pUtf8NameZ = ff.findName(p), type = ff.findType(p))) {
                        if (CairoKeywords.isTxnSeq(pUtf8NameZ) || CairoKeywords.isWal(pUtf8NameZ) || ff.unlinkOrRemove(tempPath, LOG)) continue;
                        allClean = false;
                        continue;
                    }
                    if (type != 8) continue;
                    tempPath.trimTo(rootLen);
                    tempPath.concat(pUtf8NameZ);
                    if (CairoKeywords.isTxn(pUtf8NameZ) || CairoKeywords.isMeta(pUtf8NameZ) || ApplyWal2TableJob.matchesWalLock(tempPath)) continue;
                    allClean &= ApplyWal2TableJob.removeOrLog(tempPath, ff);
                } while (ff.findNext(p) > 0);
                if (allClean) {
                    if (!ApplyWal2TableJob.removeOrLog(tempPath.trimTo(rootLen).concat("_txn"), ff)) {
                        return;
                    }
                    ff.removeQuiet(tempPath.trimTo(rootLen).concat("_meta").$());
                }
            }
            finally {
                ff.findClose(p);
            }
        }
    }

    private static boolean matchesWalLock(Utf8Sequence name) {
        int i;
        if (Utf8s.endsWithAscii(name, ".lock")) {
            for (i = name.size() - ".lock".length() - 1; i > 0; --i) {
                byte b = name.byteAt(i);
                if (b >= 48 && b <= 57) continue;
                return Utf8s.equalsAscii("wal", 0, "wal".length(), name, i - "wal".length() + 1, i + 1);
            }
        }
        int n = name.size();
        for (i = 0; i < n; ++i) {
            byte b = name.byteAt(i);
            if (b >= 48 && b <= 57) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static void purgeTableFiles(TableToken tableToken, @Nullable TableWriter writer, CairoEngine engine, Path tempPath) {
        block8: {
            block9: {
                if (!engine.lockReadersAndMetadata(tableToken)) break block9;
                writerToClose = null;
                try {
                    configuration = engine.getConfiguration();
                    if (writer != null || TableUtils.exists(configuration.getFilesFacade(), tempPath, (CharSequence)configuration.getDbRoot(), tableToken.getDirName()) != 0) ** GOTO lbl-1000
                    try {
                        writer = writerToClose = engine.getWriterUnsafe(tableToken, "WAL Data Application");
                        ** GOTO lbl-1000
                    }
                    catch (EntryUnavailableException ex) {
                        Misc.free(writerToClose);
                        engine.unlockReadersAndMetadata(tableToken);
                        return;
                    }
                    catch (CairoException var6_7) {
                        if (writer != null) {
                            writer.destroy();
                        }
                        ApplyWal2TableJob.cleanDroppedTableDirectory(engine, tempPath, tableToken);
                        break block8;
                    }
                }
                finally {
                    Misc.free(writerToClose);
                    engine.unlockReadersAndMetadata(tableToken);
                }
            }
            ApplyWal2TableJob.LOG.info().$("table is dropped, waiting to acquire Table Readers lock to delete the table files [table=").$(tableToken).I$();
        }
    }

    private static boolean removeOrLog(Path path, FilesFacade ff) {
        if (!ff.removeQuiet(path.$())) {
            LOG.info().$("could not remove, will retry [path=").$(path).$(", errno=").$(ff.errno()).I$();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyOutstandingWalTransactions(TableToken tableToken, TableWriter writer, CairoEngine engine, OperationExecutor operationExecutor, Path tempPath, Job.RunStatus runStatus, TableWriterPressureControl pressureControl) {
        TableSequencerAPI tableSequencerAPI = engine.getTableSequencerAPI();
        boolean finishedAll = true;
        long initialSeqTxn = writer.getSeqTxn();
        this.mvRefreshTask.clear();
        this.mvRefreshTask.operation = 0;
        this.mvRefreshTask.baseTableToken = writer.getTableToken();
        try (TransactionLogCursor transactionLogCursor = tableSequencerAPI.getCursor(tableToken, writer.getAppliedSeqTxn());){
            TableMetadataChangeLog structuralChangeCursor = null;
            try {
                int iTransaction = 0;
                int totalTransactionCount = 0;
                long rowsAdded = 0L;
                long physicalRowsAdded = 0L;
                long insertTimespan = 0L;
                tempPath.of(engine.getConfiguration().getDbRoot()).concat(tableToken).slash();
                writer.readWalTxnDetails(transactionLogCursor);
                transactionLogCursor.toTop();
                boolean isTerminating = runStatus.isTerminating();
                long timeLimit = this.microClock.getTicks() + this.tableTimeQuotaMicros;
                boolean firstRun = true;
                try {
                    block22: while (!isTerminating && ((finishedAll = this.microClock.getTicks() <= timeLimit) || firstRun) && transactionLogCursor.hasNext()) {
                        long start;
                        long seqTxn;
                        firstRun = false;
                        int walId = transactionLogCursor.getWalId();
                        int segmentId = transactionLogCursor.getSegmentId();
                        long segmentTxn = transactionLogCursor.getSegmentTxn();
                        long commitTimestamp = transactionLogCursor.getCommitTimestamp();
                        this.lastAttemptSeqTxn = seqTxn = transactionLogCursor.getTxn();
                        if (seqTxn != writer.getAppliedSeqTxn() + 1L) {
                            throw CairoException.critical(0).put("unexpected sequencer transaction, expected ").put(writer.getAppliedSeqTxn() + 1L).put(" but was ").put(seqTxn);
                        }
                        switch (walId) {
                            case -1: {
                                boolean hasNext;
                                long newStructureVersion = transactionLogCursor.getStructureVersion();
                                if (writer.getColumnStructureVersion() != newStructureVersion - 1L) {
                                    throw CairoException.critical(0).put("unexpected new WAL structure version [walStructure=").put(newStructureVersion).put(", tableStructureVersion=").put(writer.getColumnStructureVersion()).put(']');
                                }
                                if (structuralChangeCursor == null || !(hasNext = structuralChangeCursor.hasNext())) {
                                    Misc.free(structuralChangeCursor);
                                    structuralChangeCursor = tableSequencerAPI.getMetadataChangeLogSlow(tableToken, newStructureVersion - 1L);
                                    hasNext = structuralChangeCursor.hasNext();
                                }
                                if (!hasNext) throw CairoException.critical(0).put("could not apply structure change from WAL to table. WAL metadata change does not exist [structureVersion=").put(newStructureVersion).put(']');
                                start = this.microClock.getTicks();
                                this.walTelemetryFacade.store((short)103, tableToken, walId, seqTxn, -1L, -1L, start - commitTimestamp);
                                writer.setSeqTxn(seqTxn);
                                try {
                                    TableMetadataChange metadataChangeOp = structuralChangeCursor.next();
                                    metadataChangeOp.apply(writer, true);
                                    String matViewInvalidationReason = metadataChangeOp.matViewInvalidationReason();
                                    if (matViewInvalidationReason != null) {
                                        this.mvRefreshTask.operation = 3;
                                        this.mvRefreshTask.invalidationReason = matViewInvalidationReason;
                                    }
                                }
                                catch (Throwable th) {
                                    writer.setSeqTxn(seqTxn - 1L);
                                    throw th;
                                }
                                this.walTelemetryFacade.store((short)104, tableToken, walId, seqTxn, -1L, -1L, this.microClock.getTicks() - start);
                                continue block22;
                            }
                            case -2: {
                                engine.notifyDropped(tableToken);
                                ApplyWal2TableJob.purgeTableFiles(tableToken, writer, engine, tempPath);
                                return;
                            }
                            case 0: {
                                throw CairoException.critical(0).put("broken table transaction record in sequencer log, walId cannot be 0 [table=").put(tableToken.getTableName()).put(", seqTxn=").put(seqTxn).put(']');
                            }
                        }
                        operationExecutor.setNowAndFixClock(commitTimestamp);
                        tempPath.of(engine.getConfiguration().getDbRoot()).concat(tableToken).slash().putAscii("wal").put(walId).slash().put(segmentId);
                        start = this.microClock.getTicks();
                        long lastLoadedTxnDetails = writer.getWalTnxDetails().getLastSeqTxn();
                        if (seqTxn > lastLoadedTxnDetails || lastLoadedTxnDetails < seqTxn + (long)this.config.getWalApplyLookAheadTransactionCount() && (transactionLogCursor.getMaxTxn() > lastLoadedTxnDetails || transactionLogCursor.extend())) {
                            writer.readWalTxnDetails(transactionLogCursor);
                            transactionLogCursor.setPosition(seqTxn);
                        }
                        assert (walId == writer.getWalTnxDetails().getWalId(seqTxn));
                        assert (segmentId == writer.getWalTnxDetails().getSegmentId(seqTxn));
                        int txnCommitted = this.processWalCommit(writer, walId, segmentId, tempPath, segmentTxn, operationExecutor, seqTxn, commitTimestamp, pressureControl);
                        assert (txnCommitted != 0);
                        if (txnCommitted > 0) {
                            insertTimespan += this.microClock.getTicks() - start;
                            rowsAdded += this.lastCommittedRows;
                            iTransaction += txnCommitted;
                            physicalRowsAdded += writer.getPhysicallyWrittenRowsSinceLastCommit();
                            if (txnCommitted > 1) {
                                transactionLogCursor.setPosition(writer.getAppliedSeqTxn());
                            }
                        }
                        if (!(isTerminating = runStatus.isTerminating())) continue;
                    }
                    totalTransactionCount += iTransaction;
                    if (!finishedAll || isTerminating) {
                        writer.commitSeqTxn();
                    }
                }
                catch (EjectApplyWalException ex) {
                    finishedAll = false;
                }
                boolean bl = finishedAll = finishedAll || writer.getAppliedSeqTxn() == transactionLogCursor.getMaxTxn() && !transactionLogCursor.hasNext();
                if (totalTransactionCount > 0) {
                    LOG.info().$("job ").$(finishedAll ? "finished" : "ejected").$(" [table=").$(writer.getTableToken()).$(", seqTxn=").$(writer.getAppliedSeqTxn()).$(", transactions=").$(totalTransactionCount).$(", rows=").$(rowsAdded).$(", time=").$(insertTimespan / 1000L).$("ms, rate=").$(rowsAdded * 1000000L / Math.max(1L, insertTimespan)).$("rows/s, ampl=").$((double)Math.round(100.0 * (double)physicalRowsAdded / (double)rowsAdded) / 100.0).I$();
                }
                if (initialSeqTxn >= writer.getSeqTxn()) return;
                engine.notifyMatViewBaseTableCommit(this.mvRefreshTask, writer.getSeqTxn());
                return;
            }
            catch (Throwable th) {
                engine.getTableSequencerAPI().updateWriterTxns(tableToken, writer.getTxn(), writer.getTxn());
                throw th;
            }
            finally {
                Misc.free(structuralChangeCursor);
            }
        }
    }

    private void doStoreTelemetry(short event, short origin) {
        TelemetryTask.store(this.telemetry, origin, event);
    }

    private void doStoreWalTelemetry(short event, TableToken tableToken, int walId, long seqTxn, long rowCount, long physicalRowCount, long latencyUs) {
        TelemetryWalTask.store(this.walTelemetry, event, tableToken.getTableId(), walId, seqTxn, rowCount, physicalRowCount, latencyUs);
    }

    private void handleWalApplyFailure(TableToken tableToken, Throwable throwable, SeqTxnTracker txnTracker) {
        String errorMessage;
        ErrorTag errorTag;
        if (this.engine.isTableDropped(tableToken)) {
            ApplyWal2TableJob.purgeTableFiles(tableToken, null, this.engine, Path.PATH.get());
            return;
        }
        if (throwable instanceof CairoException) {
            CairoException cairoException = (CairoException)throwable;
            if (cairoException.isOutOfMemory()) {
                if (txnTracker != null) {
                    txnTracker.getMemPressureControl().onOutOfMemory();
                    if (txnTracker.getMemPressureControl().isReadyToProcess()) {
                        this.engine.notifyWalTxnRepublisher(tableToken);
                        return;
                    }
                    LOG.info().$("high memory pressure, table is backed off from processing WAL transactions [table=").$(tableToken).I$();
                }
                errorTag = ErrorTag.OUT_OF_MEMORY;
            } else {
                errorTag = ErrorTag.resolveTag(cairoException.getErrno());
            }
            errorMessage = cairoException.getFlyweightMessage().toString();
        } else {
            errorTag = ErrorTag.NONE;
            errorMessage = throwable.getMessage();
        }
        try {
            this.telemetryFacade.store((short)107, (short)6);
            LogRecord logRecord = LOG.critical().$("job failed, table suspended [table=").$(tableToken);
            if (this.lastAttemptSeqTxn > -1L) {
                logRecord.$(", seqTxn=").$(this.lastAttemptSeqTxn);
            }
            logRecord.$(", error=").$(throwable).I$();
            this.engine.getTableSequencerAPI().suspendTable(tableToken, errorTag, errorMessage);
        }
        catch (CairoException e) {
            LOG.critical().$("could not suspend table [table=").$(tableToken.getTableName()).$(", error=").$safe(e.getFlyweightMessage()).I$();
        }
    }

    private int processWalCommit(TableWriter writer, int walId, int segmentId, Path walPath, long segmentTxn, OperationExecutor operationExecutor, long seqTxn, long commitTimestamp, TableWriterPressureControl pressureControl) {
        WalTxnDetails txnDetails = writer.getWalTnxDetails();
        byte walTxnType = txnDetails.getWalTxnType(seqTxn);
        long start = this.microClock.getTicks();
        switch (walTxnType) {
            case 0: 
            case 3: {
                long s;
                this.walTelemetryFacade.store((short)103, writer.getTableToken(), walId, seqTxn, -1L, -1L, start - commitTimestamp);
                writer.commitWalInsertTransactions(walPath, seqTxn, pressureControl);
                long latency = this.microClock.getTicks() - start;
                long totalPhysicalRowCount = writer.getPhysicallyWrittenRowsSinceLastCommit();
                long lastCommittedSeqTxn = writer.getAppliedSeqTxn();
                this.lastCommittedRows = 0L;
                for (s = seqTxn; s <= lastCommittedSeqTxn; ++s) {
                    long walRowCount = txnDetails.getSegmentRowHi(s) - txnDetails.getSegmentRowLo(s);
                    long commitPhRowCount = s == lastCommittedSeqTxn ? totalPhysicalRowCount : 0L;
                    this.metrics.addApplyRowsWritten(walRowCount, commitPhRowCount, latency);
                    this.walTelemetryFacade.store((short)105, writer.getTableToken(), walId, s, walRowCount, commitPhRowCount, latency);
                    this.lastCommittedRows += walRowCount;
                }
                if (writer.getTableToken().isMatView()) {
                    for (s = lastCommittedSeqTxn; s >= seqTxn; --s) {
                        byte txnType = txnDetails.getWalTxnType(s);
                        if (txnType != 3) continue;
                        try {
                            Path path = Path.PATH2.get();
                            TableToken token = writer.getTableToken();
                            path.of(this.engine.getConfiguration().getDbRoot()).concat(token);
                            this.updateMatViewRefreshState(path, txnDetails.getMatViewRefreshTxn(s), txnDetails.getMatViewRefreshTimestamp(s), false, null, txnDetails.getMatViewPeriodHi(s), null, -1L);
                        }
                        catch (CairoException e) {
                            LOG.error().$("could not update state for materialized view [view=").$(writer.getTableToken()).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                        }
                        break;
                    }
                }
                return (int)(writer.getAppliedSeqTxn() - seqTxn + 1L);
            }
            case 1: {
                try (WalEventReader eventReader = this.walEventReader;){
                    WalEventCursor walEventCursor = eventReader.of(walPath, segmentTxn);
                    WalEventCursor.SqlInfo sqlInfo = walEventCursor.getSqlInfo();
                    this.walTelemetryFacade.store((short)103, writer.getTableToken(), walId, seqTxn, -1L, -1L, start - commitTimestamp);
                    this.processWalSql(writer, sqlInfo, operationExecutor, seqTxn);
                    this.walTelemetryFacade.store((short)106, writer.getTableToken(), walId, seqTxn, -1L, -1L, this.microClock.getTicks() - start);
                    this.lastCommittedRows = 0L;
                    int e = 1;
                    return e;
                }
            }
            case 2: {
                long txn = writer.getTxn();
                writer.setSeqTxn(seqTxn);
                writer.removeAllPartitions();
                if (writer.getTxn() == txn) {
                    writer.markSeqTxnCommitted(seqTxn);
                }
                this.lastCommittedRows = 0L;
                this.mvRefreshTask.operation = 3;
                this.mvRefreshTask.invalidationReason = "truncate operation";
                return 1;
            }
            case 4: {
                try (WalEventReader eventReader = this.walEventReader;){
                    Path path = Path.PATH2.get();
                    TableToken token = writer.getTableToken();
                    path.of(this.engine.getConfiguration().getDbRoot()).concat(token);
                    int tablePathLen = path.size();
                    path.slash().putAscii("wal").put(walId).slash().put(segmentId);
                    WalEventCursor walEventCursor = eventReader.of(path, segmentTxn);
                    WalEventCursor.MatViewInvalidationInfo info = walEventCursor.getMatViewInvalidationInfo();
                    this.updateMatViewRefreshState(path.trimTo(tablePathLen), info.getLastRefreshBaseTableTxn(), info.getLastRefreshTimestamp(), info.isInvalid(), info.getInvalidationReason(), info.getLastPeriodHi(), info.getRefreshIntervals(), info.getRefreshIntervalsBaseTxn());
                }
                catch (CairoException e) {
                    LOG.error().$("could not update state for materialized view [view=").$(writer.getTableToken()).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                }
                writer.setSeqTxn(seqTxn);
                writer.markSeqTxnCommitted(seqTxn);
                this.lastCommittedRows = 0L;
                return 1;
            }
        }
        throw new UnsupportedOperationException("Unsupported WAL txn type: " + walTxnType);
    }

    private void processWalSql(TableWriter tableWriter, WalEventCursor.SqlInfo sqlInfo, OperationExecutor operationExecutor, long seqTxn) {
        int cmdType = sqlInfo.getCmdType();
        CharSequence sql = sqlInfo.getSql();
        operationExecutor.resetRnd(sqlInfo.getRndSeed0(), sqlInfo.getRndSeed1());
        sqlInfo.populateBindVariableService(operationExecutor.getBindVariableService());
        try {
            while (true) {
                TableToken tableToken;
                TableToken updatedToken;
                block19: {
                    try {
                        switch (cmdType) {
                            case 2: {
                                String matViewInvalidationReason = operationExecutor.executeAlter(tableWriter, sql, seqTxn);
                                if (matViewInvalidationReason != null) {
                                    this.mvRefreshTask.operation = 3;
                                    this.mvRefreshTask.invalidationReason = matViewInvalidationReason;
                                }
                                return;
                            }
                            case 3: {
                                long rowsAffected = operationExecutor.executeUpdate(tableWriter, sql, seqTxn);
                                if (rowsAffected > 0L) {
                                    this.mvRefreshTask.operation = 3;
                                    this.mvRefreshTask.invalidationReason = "update operation";
                                }
                                return;
                            }
                        }
                        throw new UnsupportedOperationException("Unsupported command type: " + cmdType);
                    }
                    catch (SqlException ex) {
                        if (ex.isWalRecoverable()) {
                            LOG.info().$("recoverable error applying SQL to wal table [table=").$(tableWriter.getTableToken()).$(", sql=").$(sql).$(", position=").$(ex.getPosition()).$(", error=").$safe(ex.getFlyweightMessage()).I$();
                            return;
                        }
                        if (!ex.isTableDoesNotExist()) {
                            throw ex;
                        }
                    }
                    catch (CairoException ex) {
                        if (ex.isTableDoesNotExist()) break block19;
                        throw ex;
                    }
                }
                if ((updatedToken = this.engine.getUpdatedTableToken(tableToken = tableWriter.getTableToken())) == null || tableToken.equals(updatedToken)) {
                    if (this.engine.isTableDropped(tableToken)) {
                        throw CairoException.tableDropped(tableToken);
                    }
                    LOG.info().$("failed to compile SQL, table rename not fully applied, will retry [table=").$(tableToken).I$();
                    throw EjectApplyWalException.INSTANCE;
                }
                tableWriter.updateTableToken(updatedToken);
            }
        }
        catch (SqlException ex) {
            throw CairoException.nonCritical().put("error applying SQL to wal table [table=").put(tableWriter.getTableToken().getTableName()).put(", sql=").put(sql).put(", position=").put(ex.getPosition()).put(", error=").put(ex.getFlyweightMessage());
        }
        catch (CairoException e) {
            if (e.isTableDropped()) {
                throw e;
            }
            LogRecord log = !e.isWALTolerable() ? LOG.error() : LOG.info();
            log.$("error applying SQL to wal table [table=").$(tableWriter.getTableToken()).$(", sql=").$(sql).$(", msg=").$safe(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
            if (!e.isWALTolerable()) {
                throw e;
            }
            tableWriter.commitSeqTxn(seqTxn);
            return;
        }
    }

    private void storeTelemetryNoOp(short event, short origin) {
    }

    private void storeWalTelemetryNoop(short event, TableToken tableToken, int walId, long seqTxn, long rowCount, long physicalRowCount, long latencyUs) {
    }

    private void updateMatViewRefreshState(Path tablePath, long lastRefreshBaseTxn, long lastRefreshTimestamp, boolean invalid, @Nullable CharSequence invalidationReason, long lastPeriodHi, @Nullable LongList refreshIntervals, long refreshIntervalsBaseTxn) {
        try (BlockFileWriter stateWriter = this.mvStateWriter;){
            stateWriter.of(tablePath.concat("_mv.s").$());
            MatViewState.append(lastRefreshTimestamp, lastRefreshBaseTxn, invalid, invalidationReason, lastPeriodHi, refreshIntervals, refreshIntervalsBaseTxn, stateWriter);
        }
    }

    void applyWal(@NotNull TableToken tableToken, CairoEngine engine, OperationExecutor operationExecutor, Job.RunStatus runStatus) {
        block18: {
            Path tempPath = Path.PATH.get();
            SeqTxnTracker txnTracker = null;
            this.lastAttemptSeqTxn = -1L;
            try {
                long dirtyWriterTxn;
                long writerTxn;
                TableToken updatedToken = engine.getUpdatedTableToken(tableToken);
                if (engine.isTableDropped(tableToken) || updatedToken == null) {
                    if (engine.isTableDropped(tableToken)) {
                        ApplyWal2TableJob.purgeTableFiles(tableToken, null, engine, tempPath);
                    }
                    break block18;
                }
                txnTracker = engine.getTableSequencerAPI().getTxnTracker(tableToken);
                TableWriterPressureControl pressureControl = txnTracker.getMemPressureControl();
                TableWriter writer = null;
                try {
                    writer = engine.getWriterUnsafe(updatedToken, WAL_2_TABLE_WRITE_REASON);
                    assert (writer.getMetadata().getTableId() == tableToken.getTableId());
                    if (!pressureControl.isReadyToProcess()) {
                        return;
                    }
                    this.applyOutstandingWalTransactions(tableToken, writer, engine, operationExecutor, tempPath, runStatus, pressureControl);
                    if (pressureControl.onEnoughMemory()) {
                        LOG.info().$("table writing memory pressure is easing up [table=").$(tableToken).$(", parallelMemoryLimit=").$(pressureControl.getMemoryPressureRegulationValue()).I$();
                    }
                    writerTxn = writer.getSeqTxn();
                    dirtyWriterTxn = writer.getAppliedSeqTxn();
                }
                catch (EntryUnavailableException tableBusy) {
                    if (tableBusy.getReason() != "unknown" && !WAL_2_TABLE_WRITE_REASON.equals(tableBusy.getReason()) && !WAL_2_TABLE_RESUME_REASON.equals(tableBusy.getReason())) {
                        LOG.critical().$("unsolicited table lock [table=").$(tableToken).$(", lockReason=").$(tableBusy.getReason()).I$();
                        engine.notifyWalTxnRepublisher(tableToken);
                    }
                    return;
                }
                catch (Throwable th) {
                    if (writer != null) {
                        writer.markDistressed();
                    }
                    throw th;
                }
                finally {
                    Misc.free(writer);
                }
                if (engine.getTableSequencerAPI().updateWriterTxns(tableToken, writerTxn, dirtyWriterTxn)) {
                    engine.notifyWalTxnCommitted(tableToken);
                }
            }
            catch (Throwable ex) {
                this.handleWalApplyFailure(tableToken, ex, txnTracker);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doRun(int workerId, long cursor, Job.RunStatus runStatus) {
        TableToken tableToken;
        try {
            WalTxnNotificationTask task = (WalTxnNotificationTask)this.queue.get(cursor);
            tableToken = task.getTableToken();
        }
        finally {
            this.subSeq.done(cursor);
        }
        this.applyWal(tableToken, this.engine, this.operationExecutor, runStatus);
        return true;
    }

    @FunctionalInterface
    private static interface WalTelemetryFacade {
        public void store(short var1, TableToken var2, int var3, long var4, long var6, long var8, long var10);
    }

    @FunctionalInterface
    private static interface TelemetryFacade {
        public void store(short var1, short var2);
    }

    private static class EjectApplyWalException
    extends RuntimeException {
        public static final EjectApplyWalException INSTANCE = new EjectApplyWalException();

        private EjectApplyWalException() {
        }
    }
}

