/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.arr;

import io.questdb.cairo.vm.api.MemoryA;
import io.questdb.std.Numbers;
import io.questdb.std.Unsafe;

public interface FlatArrayView {
    default public long appendPlainDoubleValue(long addr, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            Unsafe.getUnsafe().putDouble(addr, this.getDoubleAtAbsIndex(i));
            addr += 8L;
        }
        return addr;
    }

    public void appendToMemFlat(MemoryA var1, int var2, int var3);

    default public double avgDouble(int offset, int length) {
        double sum = 0.0;
        int count = 0;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            double v = this.getDoubleAtAbsIndex(i);
            if (Double.isNaN(v)) continue;
            sum += v;
            ++count;
        }
        return sum / (double)count;
    }

    default public int binarySearchDouble(double value, int offset, int length, boolean ascending, boolean forwardScan) {
        int low = offset;
        int high = offset + length - 1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            double midVal = this.getDoubleAtAbsIndex(mid);
            if (Math.abs(midVal - value) <= 1.0E-10) {
                if (forwardScan) {
                    while (low < mid) {
                        int m = low + (mid - low) / 2;
                        if (Math.abs(this.getDoubleAtAbsIndex(m) - value) <= 1.0E-10) {
                            mid = m;
                            continue;
                        }
                        low = m + 1;
                    }
                    return low - offset;
                }
                while (mid < high) {
                    int m = mid + (high - mid + 1) / 2;
                    if (Math.abs(this.getDoubleAtAbsIndex(m) - value) <= 1.0E-10) {
                        mid = m;
                        continue;
                    }
                    high = m - 1;
                }
                return mid - offset;
            }
            if (ascending) {
                if (midVal < value) {
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
                continue;
            }
            if (midVal > value) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return -(low - offset + 1);
    }

    default public int countDouble(int offset, int length) {
        int count = 0;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            if (!Numbers.isFinite(this.getDoubleAtAbsIndex(i))) continue;
            ++count;
        }
        return count;
    }

    default public int countLong(int offset, int length) {
        int count = 0;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            double v = this.getLongAtAbsIndex(i);
            if (v == -9.223372036854776E18) continue;
            ++count;
        }
        return count;
    }

    public double getDoubleAtAbsIndex(int var1);

    public long getLongAtAbsIndex(int var1);

    public int length();

    default public int linearSearch(double value, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            if (!(Math.abs(this.getDoubleAtAbsIndex(i) - value) <= 1.0E-10)) continue;
            return i - offset;
        }
        return Integer.MIN_VALUE;
    }

    default public double maxDouble(int offset, int length) {
        double max = Double.NEGATIVE_INFINITY;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            double v = this.getDoubleAtAbsIndex(i);
            if (!Numbers.isFinite(v) || !(v > max)) continue;
            max = v;
        }
        return Numbers.isFinite(max) ? max : Double.NaN;
    }

    default public double minDouble(int offset, int length) {
        double min = Double.POSITIVE_INFINITY;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            double v = this.getDoubleAtAbsIndex(i);
            if (!Numbers.isFinite(v) || !(v < min)) continue;
            min = v;
        }
        return Numbers.isFinite(min) ? min : Double.NaN;
    }

    default public double sumDouble(int offset, int length) {
        double sum = Double.NaN;
        double compensation = 0.0;
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            double v = this.getDoubleAtAbsIndex(i);
            if (!Numbers.isFinite(v)) continue;
            if (compensation == 0.0 && Numbers.isNull(sum)) {
                sum = 0.0;
            }
            double y = v - compensation;
            double t = sum + y;
            compensation = t - sum - y;
            sum = t;
        }
        return sum;
    }
}

