/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.async.PageFrameReduceTask;
import io.questdb.cutlass.text.CopyRequestTask;
import io.questdb.cutlass.text.CopyTask;
import io.questdb.metrics.QueryTrace;
import io.questdb.mp.Barrier;
import io.questdb.mp.ConcurrentQueue;
import io.questdb.mp.FanOut;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SPSequence;
import io.questdb.std.Misc;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.ColumnPurgeTask;
import io.questdb.tasks.ColumnTask;
import io.questdb.tasks.GroupByMergeShardTask;
import io.questdb.tasks.LatestByTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionPurgeTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.TableWriterTask;
import io.questdb.tasks.VectorAggregateTask;
import io.questdb.tasks.WalTxnNotificationTask;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private final MPSequence columnPurgePubSeq;
    private final RingQueue<ColumnPurgeTask> columnPurgeQueue;
    private final SCSequence columnPurgeSubSeq;
    private final MPSequence columnTaskPubSeq;
    private final RingQueue<ColumnTask> columnTaskQueue;
    private final MCSequence columnTaskSubSeq;
    private final CairoConfiguration configuration;
    private final MPSequence groupByMergeShardPubSeq;
    private final RingQueue<GroupByMergeShardTask> groupByMergeShardQueue;
    private final MCSequence groupByMergeShardSubSeq;
    private final MPSequence indexerPubSeq;
    private final RingQueue<ColumnIndexerTask> indexerQueue;
    private final MCSequence indexerSubSeq;
    private final MPSequence latestByPubSeq;
    private final RingQueue<LatestByTask> latestByQueue;
    private final MCSequence latestBySubSeq;
    private final MPSequence o3CopyPubSeq;
    private final RingQueue<O3CopyTask> o3CopyQueue;
    private final MCSequence o3CopySubSeq;
    private final MPSequence o3OpenColumnPubSeq;
    private final RingQueue<O3OpenColumnTask> o3OpenColumnQueue;
    private final MCSequence o3OpenColumnSubSeq;
    private final MPSequence o3PartitionPubSeq;
    private final RingQueue<O3PartitionTask> o3PartitionQueue;
    private final MCSequence o3PartitionSubSeq;
    private final MPSequence o3PurgeDiscoveryPubSeq;
    private final RingQueue<O3PartitionPurgeTask> o3PurgeDiscoveryQueue;
    private final MCSequence o3PurgeDiscoverySubSeq;
    private final FanOut[] pageFrameCollectFanOut;
    private final MPSequence[] pageFrameReducePubSeq;
    private final RingQueue<PageFrameReduceTask>[] pageFrameReduceQueue;
    private final int pageFrameReduceShardCount;
    private final MCSequence[] pageFrameReduceSubSeq;
    private final MPSequence queryCacheEventPubSeq;
    private final MCSequence queryCacheEventSubSeq;
    private final ConcurrentQueue<QueryTrace> queryTraceQueue;
    private final MPSequence tableWriterEventPubSeq;
    private final RingQueue<TableWriterTask> tableWriterEventQueue;
    private final FanOut tableWriterEventSubSeq;
    private final SCSequence textImportColSeq;
    private final SPSequence textImportPubSeq;
    private final RingQueue<CopyTask> textImportQueue;
    private final MPSequence textImportRequestPubSeq;
    private final RingQueue<CopyRequestTask> textImportRequestQueue;
    private final SCSequence textImportRequestSubSeq;
    private final MCSequence textImportSubSeq;
    private final MPSequence vectorAggregatePubSeq;
    private final RingQueue<VectorAggregateTask> vectorAggregateQueue;
    private final MCSequence vectorAggregateSubSeq;
    private final MPSequence walTxnNotificationPubSequence;
    private final RingQueue<WalTxnNotificationTask> walTxnNotificationQueue;
    private final MCSequence walTxnNotificationSubSequence;

    public MessageBusImpl(@NotNull CairoConfiguration configuration) {
        try {
            this.configuration = configuration;
            this.indexerQueue = new RingQueue<ColumnIndexerTask>(ColumnIndexerTask::new, configuration.getColumnIndexerQueueCapacity());
            this.indexerPubSeq = new MPSequence(this.indexerQueue.getCycle());
            this.indexerSubSeq = new MCSequence(this.indexerQueue.getCycle());
            this.indexerPubSeq.then(this.indexerSubSeq).then(this.indexerPubSeq);
            this.vectorAggregateQueue = new RingQueue<VectorAggregateTask>(VectorAggregateTask::new, configuration.getVectorAggregateQueueCapacity());
            this.vectorAggregatePubSeq = new MPSequence(this.vectorAggregateQueue.getCycle());
            this.vectorAggregateSubSeq = new MCSequence(this.vectorAggregateQueue.getCycle());
            this.vectorAggregatePubSeq.then(this.vectorAggregateSubSeq).then(this.vectorAggregatePubSeq);
            this.columnTaskQueue = new RingQueue<ColumnTask>(ColumnTask::new, configuration.getO3CallbackQueueCapacity());
            this.columnTaskPubSeq = new MPSequence(this.columnTaskQueue.getCycle());
            this.columnTaskSubSeq = new MCSequence(this.columnTaskQueue.getCycle());
            this.columnTaskPubSeq.then(this.columnTaskSubSeq).then(this.columnTaskPubSeq);
            this.o3PartitionQueue = new RingQueue<O3PartitionTask>(O3PartitionTask::new, configuration.getO3PartitionQueueCapacity());
            this.o3PartitionPubSeq = new MPSequence(this.o3PartitionQueue.getCycle());
            this.o3PartitionSubSeq = new MCSequence(this.o3PartitionQueue.getCycle());
            this.o3PartitionPubSeq.then(this.o3PartitionSubSeq).then(this.o3PartitionPubSeq);
            this.o3OpenColumnQueue = new RingQueue<O3OpenColumnTask>(O3OpenColumnTask::new, configuration.getO3OpenColumnQueueCapacity());
            this.o3OpenColumnPubSeq = new MPSequence(this.o3OpenColumnQueue.getCycle());
            this.o3OpenColumnSubSeq = new MCSequence(this.o3OpenColumnQueue.getCycle());
            this.o3OpenColumnPubSeq.then(this.o3OpenColumnSubSeq).then(this.o3OpenColumnPubSeq);
            this.o3CopyQueue = new RingQueue<O3CopyTask>(O3CopyTask::new, configuration.getO3CopyQueueCapacity());
            this.o3CopyPubSeq = new MPSequence(this.o3CopyQueue.getCycle());
            this.o3CopySubSeq = new MCSequence(this.o3CopyQueue.getCycle());
            this.o3CopyPubSeq.then(this.o3CopySubSeq).then(this.o3CopyPubSeq);
            this.o3PurgeDiscoveryQueue = new RingQueue<O3PartitionPurgeTask>(O3PartitionPurgeTask::new, configuration.getO3PurgeDiscoveryQueueCapacity());
            this.o3PurgeDiscoveryPubSeq = new MPSequence(this.o3PurgeDiscoveryQueue.getCycle());
            this.o3PurgeDiscoverySubSeq = new MCSequence(this.o3PurgeDiscoveryQueue.getCycle());
            this.o3PurgeDiscoveryPubSeq.then(this.o3PurgeDiscoverySubSeq).then(this.o3PurgeDiscoveryPubSeq);
            this.latestByQueue = new RingQueue<LatestByTask>(LatestByTask::new, configuration.getLatestByQueueCapacity());
            this.latestByPubSeq = new MPSequence(this.latestByQueue.getCycle());
            this.latestBySubSeq = new MCSequence(this.latestByQueue.getCycle());
            this.latestByPubSeq.then(this.latestBySubSeq).then(this.latestByPubSeq);
            this.tableWriterEventQueue = new RingQueue<TableWriterTask>(TableWriterTask::new, configuration.getWriterCommandQueueSlotSize(), configuration.getWriterCommandQueueCapacity(), 51);
            this.tableWriterEventPubSeq = new MPSequence(this.tableWriterEventQueue.getCycle());
            this.tableWriterEventSubSeq = new FanOut(new Barrier[0]);
            this.tableWriterEventPubSeq.then(this.tableWriterEventSubSeq).then(this.tableWriterEventPubSeq);
            this.columnPurgeQueue = new RingQueue<ColumnPurgeTask>(ColumnPurgeTask::new, configuration.getColumnPurgeQueueCapacity());
            this.columnPurgeSubSeq = new SCSequence();
            this.columnPurgePubSeq = new MPSequence(this.columnPurgeQueue.getCycle());
            this.columnPurgePubSeq.then(this.columnPurgeSubSeq).then(this.columnPurgePubSeq);
            this.pageFrameReduceShardCount = configuration.getPageFrameReduceShardCount();
            this.pageFrameReduceQueue = new RingQueue[this.pageFrameReduceShardCount];
            this.pageFrameReducePubSeq = new MPSequence[this.pageFrameReduceShardCount];
            this.pageFrameReduceSubSeq = new MCSequence[this.pageFrameReduceShardCount];
            this.pageFrameCollectFanOut = new FanOut[this.pageFrameReduceShardCount];
            int reduceQueueCapacity = configuration.getPageFrameReduceQueueCapacity();
            for (int i = 0; i < this.pageFrameReduceShardCount; ++i) {
                FanOut collectFanOut;
                MCSequence reduceSubSeq;
                MPSequence reducePubSeq;
                this.pageFrameReduceQueue[i] = new RingQueue<PageFrameReduceTask>(() -> new PageFrameReduceTask(configuration, 46), reduceQueueCapacity);
                this.pageFrameReducePubSeq[i] = reducePubSeq = new MPSequence(reduceQueueCapacity);
                this.pageFrameReduceSubSeq[i] = reduceSubSeq = new MCSequence(reduceQueueCapacity);
                this.pageFrameCollectFanOut[i] = collectFanOut = new FanOut(new Barrier[0]);
                reducePubSeq.then(reduceSubSeq).then(collectFanOut).then(reducePubSeq);
            }
            this.textImportQueue = new RingQueue<CopyTask>(CopyTask::new, configuration.getSqlCopyQueueCapacity());
            this.textImportPubSeq = new SPSequence(this.textImportQueue.getCycle());
            this.textImportSubSeq = new MCSequence(this.textImportQueue.getCycle());
            this.textImportColSeq = new SCSequence();
            this.textImportPubSeq.then(this.textImportSubSeq).then(this.textImportColSeq).then(this.textImportPubSeq);
            this.textImportRequestQueue = new RingQueue<CopyRequestTask>(CopyRequestTask::new, 1);
            this.textImportRequestPubSeq = new MPSequence(this.textImportRequestQueue.getCycle());
            this.textImportRequestSubSeq = new SCSequence();
            this.textImportRequestPubSeq.then(this.textImportRequestSubSeq).then(this.textImportRequestPubSeq);
            this.walTxnNotificationQueue = new RingQueue<WalTxnNotificationTask>(WalTxnNotificationTask::new, configuration.getWalTxnNotificationQueueCapacity());
            this.walTxnNotificationPubSequence = new MPSequence(this.walTxnNotificationQueue.getCycle());
            this.walTxnNotificationSubSequence = new MCSequence(this.walTxnNotificationQueue.getCycle());
            this.walTxnNotificationPubSequence.then(this.walTxnNotificationSubSequence).then(this.walTxnNotificationPubSequence);
            this.groupByMergeShardQueue = new RingQueue<GroupByMergeShardTask>(GroupByMergeShardTask::new, configuration.getGroupByMergeShardQueueCapacity());
            this.groupByMergeShardPubSeq = new MPSequence(this.groupByMergeShardQueue.getCycle());
            this.groupByMergeShardSubSeq = new MCSequence(this.groupByMergeShardQueue.getCycle());
            this.groupByMergeShardPubSeq.then(this.groupByMergeShardSubSeq).then(this.groupByMergeShardPubSeq);
            this.queryCacheEventPubSeq = new MPSequence(configuration.getQueryCacheEventQueueCapacity());
            this.queryCacheEventSubSeq = new MCSequence(configuration.getQueryCacheEventQueueCapacity());
            this.queryCacheEventPubSeq.then(this.queryCacheEventSubSeq).then(this.queryCacheEventPubSeq);
            this.queryTraceQueue = ConcurrentQueue.createConcurrentQueue(QueryTrace.ITEM_FACTORY);
        }
        catch (Throwable th) {
            this.close();
            throw th;
        }
    }

    public void clear() {
        int i;
        this.columnPurgeSubSeq.clear();
        this.groupByMergeShardSubSeq.clear();
        this.indexerSubSeq.clear();
        this.latestBySubSeq.clear();
        this.columnTaskSubSeq.clear();
        this.o3CopySubSeq.clear();
        this.o3OpenColumnSubSeq.clear();
        this.o3PartitionSubSeq.clear();
        this.o3PurgeDiscoverySubSeq.clear();
        this.textImportColSeq.clear();
        this.textImportRequestSubSeq.clear();
        this.textImportSubSeq.clear();
        this.vectorAggregateSubSeq.clear();
        this.walTxnNotificationSubSequence.clear();
        this.walTxnNotificationSubSequence.clear();
        int n = this.pageFrameReduceSubSeq.length;
        for (i = 0; i < n; ++i) {
            this.pageFrameReduceSubSeq[i].clear();
        }
        for (i = 0; i < this.pageFrameReduceShardCount; ++i) {
            int n2 = this.pageFrameReduceQueue[i].getCycle();
            for (int j = 0; j < n2; ++j) {
                this.pageFrameReduceQueue[i].get(j).clear();
            }
        }
        n = this.latestByQueue.getCycle();
        for (i = 0; i < n; ++i) {
            this.latestByQueue.get(i).clear();
        }
    }

    @Override
    public void close() {
        Misc.free(this.tableWriterEventQueue);
        Misc.free(this.pageFrameReduceQueue);
        Misc.free(this.latestByQueue);
    }

    @Override
    public MPSequence getColumnPurgePubSeq() {
        return this.columnPurgePubSeq;
    }

    @Override
    public RingQueue<ColumnPurgeTask> getColumnPurgeQueue() {
        return this.columnPurgeQueue;
    }

    @Override
    public SCSequence getColumnPurgeSubSeq() {
        return this.columnPurgeSubSeq;
    }

    @Override
    public MPSequence getColumnTaskPubSeq() {
        return this.columnTaskPubSeq;
    }

    @Override
    public RingQueue<ColumnTask> getColumnTaskQueue() {
        return this.columnTaskQueue;
    }

    @Override
    public MCSequence getColumnTaskSubSeq() {
        return this.columnTaskSubSeq;
    }

    @Override
    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MPSequence getCopyRequestPubSeq() {
        return this.textImportRequestPubSeq;
    }

    @Override
    public MPSequence getGroupByMergeShardPubSeq() {
        return this.groupByMergeShardPubSeq;
    }

    @Override
    public RingQueue<GroupByMergeShardTask> getGroupByMergeShardQueue() {
        return this.groupByMergeShardQueue;
    }

    @Override
    public MCSequence getGroupByMergeShardSubSeq() {
        return this.groupByMergeShardSubSeq;
    }

    @Override
    public MPSequence getIndexerPubSequence() {
        return this.indexerPubSeq;
    }

    @Override
    public RingQueue<ColumnIndexerTask> getIndexerQueue() {
        return this.indexerQueue;
    }

    @Override
    public MCSequence getIndexerSubSequence() {
        return this.indexerSubSeq;
    }

    @Override
    public MPSequence getLatestByPubSeq() {
        return this.latestByPubSeq;
    }

    @Override
    public RingQueue<LatestByTask> getLatestByQueue() {
        return this.latestByQueue;
    }

    @Override
    public MCSequence getLatestBySubSeq() {
        return this.latestBySubSeq;
    }

    @Override
    public MPSequence getO3CopyPubSeq() {
        return this.o3CopyPubSeq;
    }

    @Override
    public RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.o3CopyQueue;
    }

    @Override
    public MCSequence getO3CopySubSeq() {
        return this.o3CopySubSeq;
    }

    @Override
    public MPSequence getO3OpenColumnPubSeq() {
        return this.o3OpenColumnPubSeq;
    }

    @Override
    public RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.o3OpenColumnQueue;
    }

    @Override
    public MCSequence getO3OpenColumnSubSeq() {
        return this.o3OpenColumnSubSeq;
    }

    @Override
    public MPSequence getO3PartitionPubSeq() {
        return this.o3PartitionPubSeq;
    }

    @Override
    public RingQueue<O3PartitionTask> getO3PartitionQueue() {
        return this.o3PartitionQueue;
    }

    @Override
    public MCSequence getO3PartitionSubSeq() {
        return this.o3PartitionSubSeq;
    }

    @Override
    public MPSequence getO3PurgeDiscoveryPubSeq() {
        return this.o3PurgeDiscoveryPubSeq;
    }

    @Override
    public RingQueue<O3PartitionPurgeTask> getO3PurgeDiscoveryQueue() {
        return this.o3PurgeDiscoveryQueue;
    }

    @Override
    public MCSequence getO3PurgeDiscoverySubSeq() {
        return this.o3PurgeDiscoverySubSeq;
    }

    @Override
    public FanOut getPageFrameCollectFanOut(int shard) {
        return this.pageFrameCollectFanOut[shard];
    }

    @Override
    public MPSequence getPageFrameReducePubSeq(int shard) {
        return this.pageFrameReducePubSeq[shard];
    }

    @Override
    public RingQueue<PageFrameReduceTask> getPageFrameReduceQueue(int shard) {
        return this.pageFrameReduceQueue[shard];
    }

    @Override
    public int getPageFrameReduceShardCount() {
        return this.pageFrameReduceShardCount;
    }

    @Override
    public MCSequence getPageFrameReduceSubSeq(int shard) {
        return this.pageFrameReduceSubSeq[shard];
    }

    @Override
    public MPSequence getQueryCacheEventPubSeq() {
        return this.queryCacheEventPubSeq;
    }

    @Override
    public MCSequence getQueryCacheEventSubSeq() {
        return this.queryCacheEventSubSeq;
    }

    @Override
    public ConcurrentQueue<QueryTrace> getQueryTraceQueue() {
        return this.queryTraceQueue;
    }

    @Override
    public FanOut getTableWriterEventFanOut() {
        return this.tableWriterEventSubSeq;
    }

    @Override
    public MPSequence getTableWriterEventPubSeq() {
        return this.tableWriterEventPubSeq;
    }

    @Override
    public RingQueue<TableWriterTask> getTableWriterEventQueue() {
        return this.tableWriterEventQueue;
    }

    @Override
    public SCSequence getTextImportColSeq() {
        return this.textImportColSeq;
    }

    @Override
    public SPSequence getTextImportPubSeq() {
        return this.textImportPubSeq;
    }

    @Override
    public RingQueue<CopyTask> getTextImportQueue() {
        return this.textImportQueue;
    }

    @Override
    public RingQueue<CopyRequestTask> getTextImportRequestQueue() {
        return this.textImportRequestQueue;
    }

    @Override
    public SCSequence getTextImportRequestSubSeq() {
        return this.textImportRequestSubSeq;
    }

    @Override
    public MCSequence getTextImportSubSeq() {
        return this.textImportSubSeq;
    }

    @Override
    public MPSequence getVectorAggregatePubSeq() {
        return this.vectorAggregatePubSeq;
    }

    @Override
    public RingQueue<VectorAggregateTask> getVectorAggregateQueue() {
        return this.vectorAggregateQueue;
    }

    @Override
    public MCSequence getVectorAggregateSubSeq() {
        return this.vectorAggregateSubSeq;
    }

    @Override
    public MPSequence getWalTxnNotificationPubSequence() {
        return this.walTxnNotificationPubSequence;
    }

    @Override
    public RingQueue<WalTxnNotificationTask> getWalTxnNotificationQueue() {
        return this.walTxnNotificationQueue;
    }

    @Override
    public MCSequence getWalTxnNotificationSubSequence() {
        return this.walTxnNotificationSubSequence;
    }
}

