/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.StealJobQueue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestStealJobQueue {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestStealJobQueue.class);
    StealJobQueue<Integer> stealJobQueue;
    BlockingQueue<Integer> stealFromQueue;

    @Before
    public void setup() {
        this.stealJobQueue = new StealJobQueue(Integer::compare);
        this.stealFromQueue = this.stealJobQueue.getStealFromQueue();
    }

    @Test
    public void testTake() throws InterruptedException {
        this.stealJobQueue.offer((Object)3);
        this.stealFromQueue.offer(10);
        this.stealJobQueue.offer((Object)15);
        this.stealJobQueue.offer((Object)4);
        Assert.assertEquals((long)3L, (long)((Integer)this.stealJobQueue.take()).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)this.stealJobQueue.take()).intValue());
        Assert.assertEquals((String)"always take from the main queue before trying to steal", (long)15L, (long)((Integer)this.stealJobQueue.take()).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)this.stealJobQueue.take()).intValue());
        Assert.assertTrue((boolean)this.stealFromQueue.isEmpty());
        Assert.assertTrue((boolean)this.stealJobQueue.isEmpty());
    }

    @Test
    public void testOfferInStealQueueFromShouldUnblock() throws InterruptedException {
        final AtomicInteger taken = new AtomicInteger();
        Thread consumer = new Thread(){

            @Override
            public void run() {
                try {
                    Integer n = (Integer)TestStealJobQueue.this.stealJobQueue.take();
                    taken.set(n);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        consumer.start();
        this.stealFromQueue.offer(3);
        consumer.join(1000L);
        Assert.assertEquals((long)3L, (long)taken.get());
        consumer.interrupt();
    }

    @Test
    public void testOfferInStealJobQueueShouldUnblock() throws InterruptedException {
        final AtomicInteger taken = new AtomicInteger();
        Thread consumer = new Thread(){

            @Override
            public void run() {
                try {
                    Integer n = (Integer)TestStealJobQueue.this.stealJobQueue.take();
                    taken.set(n);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        consumer.start();
        this.stealJobQueue.offer((Object)3);
        consumer.join(1000L);
        Assert.assertEquals((long)3L, (long)taken.get());
        consumer.interrupt();
    }

    @Test
    public void testPoll() throws InterruptedException {
        this.stealJobQueue.offer((Object)3);
        this.stealFromQueue.offer(10);
        this.stealJobQueue.offer((Object)15);
        this.stealJobQueue.offer((Object)4);
        Assert.assertEquals((long)3L, (long)((Integer)this.stealJobQueue.poll(1L, TimeUnit.SECONDS)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)this.stealJobQueue.poll(1L, TimeUnit.SECONDS)).intValue());
        Assert.assertEquals((String)"always take from the main queue before trying to steal", (long)15L, (long)((Integer)this.stealJobQueue.poll(1L, TimeUnit.SECONDS)).intValue());
        Assert.assertEquals((long)10L, (long)((Integer)this.stealJobQueue.poll(1L, TimeUnit.SECONDS)).intValue());
        Assert.assertTrue((boolean)this.stealFromQueue.isEmpty());
        Assert.assertTrue((boolean)this.stealJobQueue.isEmpty());
        Assert.assertNull((Object)this.stealJobQueue.poll(10L, TimeUnit.MILLISECONDS));
    }

    @Test
    public void testPutInStealQueueFromShouldUnblockPoll() throws InterruptedException {
        final AtomicInteger taken = new AtomicInteger();
        Thread consumer = new Thread(){

            @Override
            public void run() {
                try {
                    Integer n = (Integer)TestStealJobQueue.this.stealJobQueue.poll(3L, TimeUnit.SECONDS);
                    taken.set(n);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        consumer.start();
        this.stealFromQueue.put(3);
        consumer.join(1000L);
        Assert.assertEquals((long)3L, (long)taken.get());
        consumer.interrupt();
    }

    @Test
    public void testAddInStealJobQueueShouldUnblockPoll() throws InterruptedException {
        final AtomicInteger taken = new AtomicInteger();
        Thread consumer = new Thread(){

            @Override
            public void run() {
                try {
                    Integer n = (Integer)TestStealJobQueue.this.stealJobQueue.poll(3L, TimeUnit.SECONDS);
                    taken.set(n);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        consumer.start();
        this.stealJobQueue.add((Object)3);
        consumer.join(1000L);
        Assert.assertEquals((long)3L, (long)taken.get());
        consumer.interrupt();
    }

    @Test
    public void testInteractWithThreadPool() throws InterruptedException {
        TestTask task;
        int i;
        StealJobQueue stealTasksQueue = new StealJobQueue((r1, r2) -> ((TestTask)r1).compareTo((TestTask)r2));
        final CountDownLatch stealJobCountDown = new CountDownLatch(3);
        final CountDownLatch stealFromCountDown = new CountDownLatch(3);
        ThreadPoolExecutor stealPool = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.DAYS, (BlockingQueue)stealTasksQueue){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                stealJobCountDown.countDown();
            }
        };
        stealPool.prestartAllCoreThreads();
        ThreadPoolExecutor stealFromPool = new ThreadPoolExecutor(3, 3, 1L, TimeUnit.DAYS, stealTasksQueue.getStealFromQueue()){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                super.afterExecute(r, t);
                stealFromCountDown.countDown();
            }
        };
        for (i = 0; i < 4; ++i) {
            task = new TestTask();
            stealFromPool.execute(task);
        }
        for (i = 0; i < 2; ++i) {
            task = new TestTask();
            stealPool.execute(task);
        }
        stealJobCountDown.await(1L, TimeUnit.SECONDS);
        stealFromCountDown.await(1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)stealFromCountDown.getCount());
        Assert.assertEquals((long)0L, (long)stealJobCountDown.getCount());
    }

    class TestTask
    extends Thread
    implements Comparable<TestTask> {
        TestTask() {
        }

        @Override
        public int compareTo(TestTask o) {
            return 0;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

