/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileIndexBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileIndexBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.protobuf.ProtobufMagic;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFileInfo
implements SortedMap<byte[], byte[]> {
    private static final Logger LOG = LoggerFactory.getLogger(HFileInfo.class);
    static final String RESERVED_PREFIX = "hfile.";
    static final byte[] RESERVED_PREFIX_BYTES = Bytes.toBytes((String)"hfile.");
    static final byte[] LASTKEY = Bytes.toBytes((String)"hfile.LASTKEY");
    static final byte[] AVG_KEY_LEN = Bytes.toBytes((String)"hfile.AVG_KEY_LEN");
    static final byte[] AVG_VALUE_LEN = Bytes.toBytes((String)"hfile.AVG_VALUE_LEN");
    static final byte[] CREATE_TIME_TS = Bytes.toBytes((String)"hfile.CREATE_TIME_TS");
    static final byte[] TAGS_COMPRESSED = Bytes.toBytes((String)"hfile.TAGS_COMPRESSED");
    public static final byte[] MAX_TAGS_LEN = Bytes.toBytes((String)"hfile.MAX_TAGS_LEN");
    private final SortedMap<byte[], byte[]> map = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private static final int MIN_V2_MINOR_VERSION_WITH_PB = 3;
    static final int MAX_MINOR_VERSION = 3;
    private Cell lastKeyCell = null;
    private int avgKeyLen = -1;
    private int avgValueLen = -1;
    private boolean includesMemstoreTS = false;
    private boolean decodeMemstoreTS = false;
    private List<HFileBlock> loadOnOpenBlocks = new ArrayList<HFileBlock>();
    private HFileBlock.BlockIterator blockIter;
    private HFileBlockIndex.CellBasedKeyBlockIndexReader dataIndexReader;
    private HFileBlockIndex.ByteArrayKeyBlockIndexReader metaIndexReader;
    private FixedFileTrailer trailer;
    private HFileContext hfileContext;

    public HFileInfo() {
    }

    public HFileInfo(ReaderContext context, Configuration conf) throws IOException {
        this.initTrailerAndContext(context, conf);
    }

    public HFileInfo append(byte[] k, byte[] v, boolean checkPrefix) throws IOException {
        if (k == null || v == null) {
            throw new NullPointerException("Key nor value may be null");
        }
        if (checkPrefix && HFileInfo.isReservedFileInfoKey(k)) {
            throw new IOException("Keys with a hfile. are reserved");
        }
        this.put(k, v);
        return this;
    }

    public static boolean isReservedFileInfoKey(byte[] key) {
        return Bytes.startsWith((byte[])key, (byte[])RESERVED_PREFIX_BYTES);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Comparator<? super byte[]> comparator() {
        return this.map.comparator();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<byte[], byte[]>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public byte[] firstKey() {
        return this.map.firstKey();
    }

    @Override
    public byte[] get(Object key) {
        return (byte[])this.map.get(key);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public SortedMap<byte[], byte[]> headMap(byte[] toKey) {
        return this.map.headMap(toKey);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<byte[]> keySet() {
        return this.map.keySet();
    }

    @Override
    public byte[] lastKey() {
        return this.map.lastKey();
    }

    @Override
    public byte[] put(byte[] key, byte[] value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends byte[], ? extends byte[]> m) {
        this.map.putAll(m);
    }

    @Override
    public byte[] remove(Object key) {
        return (byte[])this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public SortedMap<byte[], byte[]> subMap(byte[] fromKey, byte[] toKey) {
        return this.map.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<byte[], byte[]> tailMap(byte[] fromKey) {
        return this.map.tailMap(fromKey);
    }

    @Override
    public Collection<byte[]> values() {
        return this.map.values();
    }

    void write(DataOutputStream out) throws IOException {
        HFileProtos.FileInfoProto.Builder builder = HFileProtos.FileInfoProto.newBuilder();
        for (Map.Entry<byte[], byte[]> e : this.map.entrySet()) {
            HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
            bbpBuilder.setFirst(UnsafeByteOperations.unsafeWrap((byte[])e.getKey()));
            bbpBuilder.setSecond(UnsafeByteOperations.unsafeWrap((byte[])e.getValue()));
            builder.addMapEntry(bbpBuilder.build());
        }
        out.write(ProtobufMagic.PB_MAGIC);
        builder.build().writeDelimitedTo((OutputStream)out);
    }

    void read(DataInputStream in) throws IOException {
        int read;
        int pblen = ProtobufUtil.lengthOfPBMagic();
        byte[] pbuf = new byte[pblen];
        if (in.markSupported()) {
            in.mark(pblen);
        }
        if ((read = in.read(pbuf)) != pblen) {
            throw new IOException("read=" + read + ", wanted=" + pblen);
        }
        if (ProtobufUtil.isPBMagicPrefix((byte[])pbuf)) {
            this.parsePB(HFileProtos.FileInfoProto.parseDelimitedFrom((InputStream)in));
        } else if (in.markSupported()) {
            in.reset();
            this.parseWritable(in);
        } else {
            ByteArrayInputStream bais = new ByteArrayInputStream(pbuf);
            SequenceInputStream sis = new SequenceInputStream(bais, in);
            this.parseWritable(new DataInputStream(sis));
        }
    }

    void parseWritable(DataInputStream in) throws IOException {
        this.map.clear();
        int entries = in.readInt();
        for (int i = 0; i < entries; ++i) {
            byte[] key = Bytes.readByteArray((DataInput)in);
            in.readByte();
            byte[] value = Bytes.readByteArray((DataInput)in);
            this.map.put(key, value);
        }
    }

    void parsePB(HFileProtos.FileInfoProto fip) {
        this.map.clear();
        for (HBaseProtos.BytesBytesPair pair : fip.getMapEntryList()) {
            this.map.put(pair.getFirst().toByteArray(), pair.getSecond().toByteArray());
        }
    }

    public void initTrailerAndContext(ReaderContext context, Configuration conf) throws IOException {
        try {
            boolean isHBaseChecksum = context.getInputStreamWrapper().shouldUseHBaseChecksum();
            this.trailer = FixedFileTrailer.readFromStream(context.getInputStreamWrapper().getStream(isHBaseChecksum), context.getFileSize());
            Path path = context.getFilePath();
            this.checkFileVersion(path);
            this.hfileContext = this.createHFileContext(path, this.trailer, conf);
            context.getInputStreamWrapper().unbuffer();
        }
        catch (Throwable t) {
            IOUtils.closeQuietly((Closeable)context.getInputStreamWrapper(), e -> LOG.warn("failed to close input stream wrapper", (Throwable)e));
            throw new CorruptHFileException("Problem reading HFile Trailer from file " + context.getFilePath(), t);
        }
    }

    public void initMetaAndIndex(HFile.Reader reader) throws IOException {
        ReaderContext context = reader.getContext();
        try {
            HFileBlock b;
            HFileBlock.FSReader blockReader = reader.getUncachedBlockReader();
            this.blockIter = blockReader.blockRange(this.trailer.getLoadOnOpenDataOffset(), context.getFileSize() - (long)this.trailer.getTrailerSize());
            HFileBlock dataBlockRootIndex = this.blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX);
            HFileBlock metaBlockIndex = this.blockIter.nextBlockWithBlockType(BlockType.ROOT_INDEX);
            this.loadMetaInfo(this.blockIter, this.hfileContext);
            HFileIndexBlockEncoder indexBlockEncoder = HFileIndexBlockEncoderImpl.createFromFileInfo(this);
            this.dataIndexReader = new HFileBlockIndex.CellBasedKeyBlockIndexReaderV2(this.trailer.createComparator(), this.trailer.getNumDataIndexLevels(), indexBlockEncoder);
            this.dataIndexReader.readMultiLevelIndexRoot(dataBlockRootIndex, this.trailer.getDataIndexCount());
            reader.setDataBlockIndexReader(this.dataIndexReader);
            this.metaIndexReader = new HFileBlockIndex.ByteArrayKeyBlockIndexReader(1);
            this.metaIndexReader.readRootIndex(metaBlockIndex, this.trailer.getMetaIndexCount());
            reader.setMetaBlockIndexReader(this.metaIndexReader);
            reader.setDataBlockEncoder(HFileDataBlockEncoderImpl.createFromFileInfo(this));
            while ((b = this.blockIter.nextBlock()) != null) {
                this.loadOnOpenBlocks.add(b);
            }
            context.getInputStreamWrapper().unbuffer();
        }
        catch (Throwable t) {
            IOUtils.closeQuietly((Closeable)context.getInputStreamWrapper(), e -> LOG.warn("failed to close input stream wrapper", (Throwable)e));
            throw new CorruptHFileException("Problem reading data index and meta index from file " + context.getFilePath(), t);
        }
    }

    private HFileContext createHFileContext(Path path, FixedFileTrailer trailer, Configuration conf) throws IOException {
        HFileContextBuilder builder = new HFileContextBuilder().withHBaseCheckSum(true).withHFileName(path.getName()).withCompression(trailer.getCompressionCodec()).withDecompressionContext(trailer.getCompressionCodec().getHFileDecompressionContextForConfiguration(conf)).withCellComparator(FixedFileTrailer.createComparator(trailer.getComparatorClassName()));
        byte[] keyBytes = trailer.getEncryptionKey();
        if (keyBytes != null) {
            Encryption.Context cryptoContext = Encryption.newContext((Configuration)conf);
            Key key = EncryptionUtil.unwrapKey((Configuration)conf, (byte[])keyBytes);
            Cipher cipher = Encryption.getCipher((Configuration)conf, (String)key.getAlgorithm());
            if (cipher == null) {
                throw new IOException("Cipher '" + key.getAlgorithm() + "' is not available, path=" + path);
            }
            cryptoContext.setCipher(cipher);
            cryptoContext.setKey(key);
            builder.withEncryptionContext(cryptoContext);
        }
        HFileContext context = builder.build();
        return context;
    }

    private void loadMetaInfo(HFileBlock.BlockIterator blockIter, HFileContext hfileContext) throws IOException {
        this.read(blockIter.nextBlockWithBlockType(BlockType.FILE_INFO).getByteStream());
        byte[] creationTimeBytes = this.get(CREATE_TIME_TS);
        hfileContext.setFileCreateTime(creationTimeBytes == null ? 0L : Bytes.toLong((byte[])creationTimeBytes));
        byte[] tmp = this.get(MAX_TAGS_LEN);
        if (tmp != null) {
            hfileContext.setIncludesTags(true);
            tmp = this.get(TAGS_COMPRESSED);
            if (tmp != null && Bytes.toBoolean((byte[])tmp)) {
                hfileContext.setCompressTags(true);
            }
        }
        if (this.get(LASTKEY) != null) {
            this.lastKeyCell = new KeyValue.KeyOnlyKeyValue(this.get(LASTKEY));
        }
        this.avgKeyLen = Bytes.toInt((byte[])this.get(AVG_KEY_LEN));
        this.avgValueLen = Bytes.toInt((byte[])this.get(AVG_VALUE_LEN));
        byte[] keyValueFormatVersion = this.get(HFileWriterImpl.KEY_VALUE_VERSION);
        this.includesMemstoreTS = keyValueFormatVersion != null && Bytes.toInt((byte[])keyValueFormatVersion) == 1;
        hfileContext.setIncludesMvcc(this.includesMemstoreTS);
        if (this.includesMemstoreTS) {
            this.decodeMemstoreTS = Bytes.toLong((byte[])this.get(HFileWriterImpl.MAX_MEMSTORE_TS_KEY)) > 0L;
        }
    }

    private void checkFileVersion(Path path) {
        int majorVersion = this.trailer.getMajorVersion();
        if (majorVersion == this.getMajorVersion()) {
            return;
        }
        int minorVersion = this.trailer.getMinorVersion();
        if (majorVersion == 2 && minorVersion >= 3) {
            return;
        }
        throw new IllegalArgumentException("Invalid HFile version: major=" + this.trailer.getMajorVersion() + ", minor=" + this.trailer.getMinorVersion() + ": expected at least major=2 and minor=" + 3 + ", path=" + path);
    }

    public void close() {
        if (this.blockIter != null) {
            this.blockIter.freeBlocks();
        }
    }

    public int getMajorVersion() {
        return 3;
    }

    public void setTrailer(FixedFileTrailer trailer) {
        this.trailer = trailer;
    }

    public FixedFileTrailer getTrailer() {
        return this.trailer;
    }

    public HFileBlockIndex.CellBasedKeyBlockIndexReader getDataBlockIndexReader() {
        return this.dataIndexReader;
    }

    public HFileBlockIndex.ByteArrayKeyBlockIndexReader getMetaBlockIndexReader() {
        return this.metaIndexReader;
    }

    public HFileContext getHFileContext() {
        return this.hfileContext;
    }

    public List<HFileBlock> getLoadOnOpenBlocks() {
        return this.loadOnOpenBlocks;
    }

    public Cell getLastKeyCell() {
        return this.lastKeyCell;
    }

    public int getAvgKeyLen() {
        return this.avgKeyLen;
    }

    public int getAvgValueLen() {
        return this.avgValueLen;
    }

    public boolean shouldIncludeMemStoreTS() {
        return this.includesMemstoreTS;
    }

    public boolean isDecodeMemstoreTS() {
        return this.decodeMemstoreTS;
    }
}

