/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.collections.Lists;

public class ReflectionHelper {
    public static Method[] getLocalMethods(Class<?> clazz) {
        Method[] declaredMethods = ReflectionHelper.excludingMain(clazz);
        List<Method> defaultMethods = ReflectionHelper.getDefaultMethods(clazz);
        if (defaultMethods.isEmpty()) {
            List prunedMethods = Lists.newArrayList();
            for (Method declaredMethod : declaredMethods) {
                if (declaredMethod.isBridge()) continue;
                prunedMethods.add(declaredMethod);
            }
            return prunedMethods.toArray(new Method[0]);
        }
        Method[] result = new Method[declaredMethods.length + defaultMethods.size()];
        System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
        int index = declaredMethods.length;
        Iterator<Method> iterator = defaultMethods.iterator();
        while (iterator.hasNext()) {
            Method defaultMethod;
            result[index] = defaultMethod = iterator.next();
            ++index;
        }
        return result;
    }

    public static Method[] excludingMain(Class<?> clazz) {
        Method[] declaredMethods = clazz.getDeclaredMethods();
        LinkedList<Method> pruned = new LinkedList<Method>();
        for (Method declaredMethod : declaredMethods) {
            if ("main".equals(declaredMethod.getName()) && ReflectionHelper.isStaticVoid(declaredMethod) && ReflectionHelper.acceptsStringArray(declaredMethod)) continue;
            pruned.add(declaredMethod);
        }
        return pruned.toArray(new Method[0]);
    }

    public static <T extends Annotation> T findAnnotation(Class<?> typedTestClass, Class<T> annotation) {
        if (typedTestClass == null || annotation == null) {
            return null;
        }
        T ignore = null;
        for (Class<?> testClass = typedTestClass; testClass != null && testClass != Object.class && (ignore = (T)testClass.getAnnotation(annotation)) == null; testClass = testClass.getSuperclass()) {
        }
        return ignore;
    }

    private static boolean isStaticVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE) && Modifier.isStatic(method.getModifiers());
    }

    private static boolean acceptsStringArray(Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 0) {
            return false;
        }
        Class<?> paramType = paramTypes[0];
        return paramType.isArray() && paramType.isInstance(new String[0]);
    }

    private static List<Method> getDefaultMethods(Class<?> clazz) {
        return ReflectionHelper.getAllInterfaces(clazz).stream().flatMap(each -> Arrays.stream(each.getMethods())).filter(method -> !Modifier.isAbstract(method.getModifiers())).collect(Collectors.toList());
    }

    private static Set<Class<?>> getAllInterfaces(Class<?> clazz) {
        HashSet result = new HashSet();
        while (clazz != null && clazz != Object.class) {
            result.addAll(Arrays.asList(clazz.getInterfaces()));
            clazz = clazz.getSuperclass();
        }
        return result;
    }
}

