/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.stats;

import java.util.Optional;
import org.apache.gravitino.rel.expressions.NamedReference;
import org.apache.gravitino.rel.expressions.sorts.SortDirection;
import org.apache.gravitino.rel.expressions.sorts.SortOrder;
import org.apache.gravitino.rel.expressions.sorts.SortOrders;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

public class PartitionRange {
    private static final SortOrder DEFAULT_COMPARATOR = SortOrders.of(NamedReference.MetadataField.PARTITION_NAME_FIELD, SortDirection.ASCENDING);
    private Optional<String> lowerPartitionName = Optional.empty();
    private Optional<BoundType> lowerBoundType = Optional.empty();
    private Optional<String> upperPartitionName = Optional.empty();
    private Optional<BoundType> upperBoundType = Optional.empty();
    private SortOrder comparator = DEFAULT_COMPARATOR;
    public static final PartitionRange ALL_PARTITIONS = new PartitionRange();

    private PartitionRange() {
    }

    public static PartitionRange upTo(String upperPartitionName, BoundType upperBoundType) {
        return PartitionRange.upTo(upperPartitionName, upperBoundType, DEFAULT_COMPARATOR);
    }

    public static PartitionRange upTo(String upperPartitionName, BoundType upperBoundType, SortOrder comparator) {
        Preconditions.checkArgument(upperPartitionName != null, "Upper partition name cannot be null");
        Preconditions.checkArgument(upperBoundType != null, "Upper bound type cannot be null");
        Preconditions.checkArgument(!upperPartitionName.isEmpty(), "Upper partition name cannot be empty");
        Preconditions.checkArgument(comparator != null, "Comparator cannot be null");
        PartitionRange partitionRange = new PartitionRange();
        partitionRange.upperPartitionName = Optional.of(upperPartitionName);
        partitionRange.upperBoundType = Optional.of(upperBoundType);
        partitionRange.comparator = comparator;
        return partitionRange;
    }

    public static PartitionRange downTo(String lowerPartitionName, BoundType lowerBoundType) {
        return PartitionRange.downTo(lowerPartitionName, lowerBoundType, DEFAULT_COMPARATOR);
    }

    public static PartitionRange downTo(String lowerPartitionName, BoundType lowerBoundType, SortOrder comparator) {
        Preconditions.checkArgument(lowerPartitionName != null, "Lower partition name cannot be null");
        Preconditions.checkArgument(lowerBoundType != null, "Lower bound type cannot be null");
        Preconditions.checkArgument(comparator != null, "Comparator cannot be null");
        PartitionRange partitionRange = new PartitionRange();
        partitionRange.lowerPartitionName = Optional.of(lowerPartitionName);
        partitionRange.lowerBoundType = Optional.of(lowerBoundType);
        partitionRange.comparator = comparator;
        return partitionRange;
    }

    public static PartitionRange between(String lowerPartitionName, BoundType lowerBoundType, String upperPartitionName, BoundType upperBoundType) {
        return PartitionRange.between(lowerPartitionName, lowerBoundType, upperPartitionName, upperBoundType, DEFAULT_COMPARATOR);
    }

    public static PartitionRange between(String lowerPartitionName, BoundType lowerBoundType, String upperPartitionName, BoundType upperBoundType, SortOrder comparator) {
        Preconditions.checkArgument(lowerPartitionName != null, "Lower partition name cannot be null");
        Preconditions.checkArgument(upperPartitionName != null, "Upper partition name cannot be null");
        Preconditions.checkArgument(lowerBoundType != null, "Lower bound type cannot be null");
        Preconditions.checkArgument(upperBoundType != null, "Upper bound type cannot be null");
        Preconditions.checkArgument(comparator != null, "Comparator cannot be null");
        PartitionRange partitionRange = new PartitionRange();
        partitionRange.upperPartitionName = Optional.of(upperPartitionName);
        partitionRange.lowerPartitionName = Optional.of(lowerPartitionName);
        partitionRange.upperBoundType = Optional.of(upperBoundType);
        partitionRange.lowerBoundType = Optional.of(lowerBoundType);
        partitionRange.comparator = comparator;
        return partitionRange;
    }

    public Optional<String> lowerPartitionName() {
        return this.lowerPartitionName;
    }

    public Optional<String> upperPartitionName() {
        return this.upperPartitionName;
    }

    public Optional<BoundType> lowerBoundType() {
        return this.lowerBoundType;
    }

    public Optional<BoundType> upperBoundType() {
        return this.upperBoundType;
    }

    public SortOrder comparator() {
        return this.comparator;
    }

    public static enum BoundType {
        OPEN,
        CLOSED;

    }
}

