/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.hadoop.fs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemProvider;
import org.apache.gravitino.catalog.hadoop.fs.FileSystemUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HDFSFileSystemProvider
implements FileSystemProvider {
    public static final String IPC_FALLBACK_TO_SIMPLE_AUTH_ALLOWED = "hadoop.rpc.protection.fallback-to-simple-auth-allowed";
    public static final String SCHEME_HDFS = "hdfs";

    @Override
    public FileSystem getFileSystem(@Nonnull Path path, @Nonnull Map<String, String> config) throws IOException {
        Map<String, String> hadoopConfMap = this.additionalHDFSConfig(config);
        Configuration configuration = FileSystemUtils.createConfiguration("gravitino.bypass.", hadoopConfMap);
        return FileSystem.newInstance((URI)path.toUri(), (Configuration)configuration);
    }

    @Override
    public String scheme() {
        return SCHEME_HDFS;
    }

    @Override
    public String name() {
        return "builtin-hdfs";
    }

    private Map<String, String> additionalHDFSConfig(Map<String, String> configs) {
        HashMap additionalConfigs = Maps.newHashMap(configs);
        if (!configs.containsKey("ipc.client.connect.timeout")) {
            additionalConfigs.put("ipc.client.connect.timeout", "5000");
        }
        if (!configs.containsKey("ipc.client.ping")) {
            additionalConfigs.put("ipc.client.ping", "true");
        }
        return ImmutableMap.copyOf((Map)additionalConfigs);
    }
}

