/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.function.math;

import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.function.AbstractFunction;
import com.googlecode.aviator.runtime.function.FunctionUtils;
import com.googlecode.aviator.runtime.type.AviatorBigInt;
import com.googlecode.aviator.runtime.type.AviatorDecimal;
import com.googlecode.aviator.runtime.type.AviatorDouble;
import com.googlecode.aviator.runtime.type.AviatorLong;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;

public class MathAbsFunction
extends AbstractFunction {
    private static final long serialVersionUID = -862700689914934548L;

    @Override
    public AviatorObject call(Map<String, Object> env, AviatorObject arg1) {
        Number number = FunctionUtils.getNumberValue(arg1, env);
        if (TypeUtils.isDecimal(number)) {
            return new AviatorDecimal(((BigDecimal)number).abs(RuntimeUtils.getMathContext(env)));
        }
        if (TypeUtils.isBigInt(number)) {
            return new AviatorBigInt(((BigInteger)number).abs());
        }
        if (TypeUtils.isDouble(number)) {
            return new AviatorDouble(Math.abs(number.doubleValue()));
        }
        return AviatorLong.valueOf(Math.abs(number.longValue()));
    }

    @Override
    public String getName() {
        return "math.abs";
    }
}

