/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.cli.AreYouSure;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoClient;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchFilesetException;
import org.apache.gravitino.exceptions.NoSuchMetalakeException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;

public class DeleteFileset
extends Command {
    protected final String metalake;
    protected final String catalog;
    protected final String schema;
    protected final String fileset;
    protected final boolean force;

    public DeleteFileset(CommandContext context, String metalake, String catalog, String schema, String fileset) {
        super(context);
        this.force = context.force();
        this.metalake = metalake;
        this.catalog = catalog;
        this.schema = schema;
        this.fileset = fileset;
    }

    @Override
    public void handle() {
        NameIdentifier name = NameIdentifier.of(this.schema, this.fileset);
        boolean deleted = false;
        if (!AreYouSure.really(this.force)) {
            return;
        }
        try {
            GravitinoClient client = this.buildClient(this.metalake);
            deleted = client.loadCatalog(this.catalog).asFilesetCatalog().dropFileset(name);
        }
        catch (NoSuchMetalakeException err) {
            this.exitWithError("Unknown metalake name.");
        }
        catch (NoSuchCatalogException err) {
            this.exitWithError("Unknown catalog name.");
        }
        catch (NoSuchSchemaException err) {
            this.exitWithError("Unknown schema name.");
        }
        catch (NoSuchFilesetException err) {
            this.exitWithError("Unknown fileset name.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        if (deleted) {
            this.printInformation(this.fileset + " deleted.");
        } else {
            this.printInformation(this.fileset + " not deleted.");
        }
    }
}

