/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.hudi.backend.hms;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import org.apache.gravitino.catalog.lakehouse.hudi.HudiSchema;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.hadoop.hive.metastore.api.Database;

public class HudiHMSSchema
extends HudiSchema<Database> {
    public static Builder builder() {
        return new Builder();
    }

    private HudiHMSSchema() {
    }

    @Override
    public Database fromHudiSchema() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public static class Builder
    extends HudiSchema.Builder<Database> {
        protected HudiHMSSchema simpleBuild() {
            HudiHMSSchema schema = new HudiHMSSchema();
            schema.name = this.name;
            schema.comment = this.comment;
            schema.properties = this.properties;
            schema.auditInfo = this.auditInfo;
            return schema;
        }

        protected HudiHMSSchema buildFromSchema(Database database) {
            this.name = database.getName();
            this.comment = database.getDescription();
            this.properties = Maps.newHashMap((Map)database.getParameters());
            this.properties.put("location", database.getLocationUri());
            AuditInfo.Builder auditInfoBuilder = AuditInfo.builder();
            Optional.ofNullable(database.getOwnerName()).ifPresent(arg_0 -> ((AuditInfo.Builder)auditInfoBuilder).withCreator(arg_0));
            this.auditInfo = auditInfoBuilder.build();
            return this.simpleBuild();
        }
    }
}

