/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.listener.api.event;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.gravitino.annotation.DeveloperApi;
import org.apache.gravitino.listener.api.event.OperationType;
import org.apache.gravitino.listener.api.event.UserEvent;
import org.apache.gravitino.listener.api.info.UserInfo;
import org.apache.gravitino.utils.NameIdentifierUtil;

@DeveloperApi
public class RevokeUserRolesEvent
extends UserEvent {
    private final UserInfo revokedUserInfo;
    private final List<String> roles;

    public RevokeUserRolesEvent(String initiator, String metalake, UserInfo revokedUserInfo, List<String> roles) {
        super(initiator, NameIdentifierUtil.ofUser(metalake, revokedUserInfo.name()));
        this.revokedUserInfo = revokedUserInfo;
        this.roles = roles == null ? ImmutableList.of() : ImmutableList.copyOf(roles);
    }

    public UserInfo revokedUserInfo() {
        return this.revokedUserInfo;
    }

    public List<String> roles() {
        return this.roles;
    }

    @Override
    public OperationType operationType() {
        return OperationType.REVOKE_USER_ROLES;
    }
}

