/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog.lakehouse.paimon;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.gravitino.catalog.lakehouse.paimon.utils.TypeUtils;
import org.apache.gravitino.connector.BaseColumn;
import org.apache.gravitino.rel.Column;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;

public class GravitinoPaimonColumn
extends BaseColumn {
    private GravitinoPaimonColumn() {
    }

    public static DataField toPaimonColumn(int id, Column gravitinoColumn) {
        DataType paimonType = TypeUtils.toPaimonType(gravitinoColumn.dataType());
        DataType paimonTypeWithNullable = gravitinoColumn.nullable() ? paimonType.nullable() : paimonType.notNull();
        return new DataField(id, gravitinoColumn.name(), paimonTypeWithNullable, gravitinoColumn.comment());
    }

    public static List<GravitinoPaimonColumn> fromPaimonRowType(RowType rowType) {
        return rowType.getFields().stream().map(GravitinoPaimonColumn::fromPaimonColumn).collect(Collectors.toList());
    }

    public static GravitinoPaimonColumn fromPaimonColumn(DataField dataField) {
        return (GravitinoPaimonColumn)((Builder)((Builder)((Builder)((Builder)GravitinoPaimonColumn.builder().withName(dataField.name())).withType(TypeUtils.fromPaimonType(dataField.type()))).withComment(dataField.description())).withNullable(dataField.type().isNullable())).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GravitinoPaimonColumn)) {
            return false;
        }
        GravitinoPaimonColumn other = (GravitinoPaimonColumn)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GravitinoPaimonColumn;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Builder
    extends BaseColumn.BaseColumnBuilder<Builder, GravitinoPaimonColumn> {
        private Builder() {
        }

        protected GravitinoPaimonColumn internalBuild() {
            GravitinoPaimonColumn paimonColumn = new GravitinoPaimonColumn();
            paimonColumn.name = this.name;
            paimonColumn.comment = this.comment;
            paimonColumn.dataType = this.dataType;
            paimonColumn.nullable = this.nullable;
            paimonColumn.autoIncrement = this.autoIncrement;
            paimonColumn.defaultValue = this.defaultValue == null ? Column.DEFAULT_VALUE_NOT_SET : this.defaultValue;
            return paimonColumn;
        }
    }
}

