/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.paimon.jdbc.JdbcCatalogOptions;
import org.apache.paimon.jdbc.JdbcClientPool;
import org.apache.paimon.jdbc.JdbcDistributedLockDialect;
import org.apache.paimon.options.Options;

public abstract class AbstractDistributedLockDialect
implements JdbcDistributedLockDialect {
    @Override
    public void createTable(JdbcClientPool connections, Options options) throws SQLException, InterruptedException {
        Integer lockKeyMaxLength = JdbcCatalogOptions.lockKeyMaxLength(options);
        connections.run(conn -> {
            DatabaseMetaData dbMeta = conn.getMetaData();
            ResultSet tableExists = dbMeta.getTables(null, null, "paimon_distributed_locks", null);
            if (tableExists.next()) {
                return true;
            }
            String createDistributedLockTableSql = String.format(this.getCreateTableSql(), lockKeyMaxLength);
            return conn.prepareStatement(createDistributedLockTableSql).execute();
        });
    }

    public abstract String getCreateTableSql();

    @Override
    public boolean lockAcquire(JdbcClientPool connections, String lockId, long timeoutMillSeconds) throws SQLException, InterruptedException {
        return (Boolean)connections.run(connection -> {
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.getLockAcquireSql());){
                preparedStatement.setString(1, lockId);
                preparedStatement.setLong(2, timeoutMillSeconds / 1000L);
                Boolean bl = preparedStatement.executeUpdate() > 0;
                return bl;
            }
            catch (SQLException ex) {
                return false;
            }
        });
    }

    public abstract String getLockAcquireSql();

    @Override
    public boolean releaseLock(JdbcClientPool connections, String lockId) throws SQLException, InterruptedException {
        return (Boolean)connections.run(connection -> {
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.getReleaseLockSql());){
                preparedStatement.setString(1, lockId);
                Boolean bl = preparedStatement.executeUpdate() > 0;
                return bl;
            }
        });
    }

    public abstract String getReleaseLockSql();

    @Override
    public int tryReleaseTimedOutLock(JdbcClientPool connections, String lockId) throws SQLException, InterruptedException {
        return (Integer)connections.run(connection -> {
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.getTryReleaseTimedOutLock());){
                preparedStatement.setString(1, lockId);
                Integer n = preparedStatement.executeUpdate();
                return n;
            }
        });
    }

    public abstract String getTryReleaseTimedOutLock();
}

