/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.utils.Preconditions;

@Public
public final class Decimal
implements Comparable<Decimal>,
Serializable {
    private static final long serialVersionUID = 1L;
    static final int MAX_LONG_DIGITS = 18;
    static final long[] POW10 = new long[19];
    final int precision;
    final int scale;
    final long longVal;
    BigDecimal decimalVal;

    Decimal(int precision, int scale, long longVal, BigDecimal decimalVal) {
        this.precision = precision;
        this.scale = scale;
        this.longVal = longVal;
        this.decimalVal = decimalVal;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public BigDecimal toBigDecimal() {
        BigDecimal bd = this.decimalVal;
        if (bd == null) {
            this.decimalVal = bd = BigDecimal.valueOf(this.longVal, this.scale);
        }
        return bd;
    }

    public long toUnscaledLong() {
        if (this.isCompact()) {
            return this.longVal;
        }
        return this.toBigDecimal().unscaledValue().longValueExact();
    }

    public byte[] toUnscaledBytes() {
        return this.toBigDecimal().unscaledValue().toByteArray();
    }

    public boolean isCompact() {
        return this.precision <= 18;
    }

    public Decimal copy() {
        return new Decimal(this.precision, this.scale, this.longVal, this.decimalVal);
    }

    public int hashCode() {
        return this.toBigDecimal().hashCode();
    }

    @Override
    public int compareTo(@Nonnull Decimal that) {
        if (this.isCompact() && that.isCompact() && this.scale == that.scale) {
            return Long.compare(this.longVal, that.longVal);
        }
        return this.toBigDecimal().compareTo(that.toBigDecimal());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Decimal)) {
            return false;
        }
        Decimal that = (Decimal)o;
        return this.compareTo(that) == 0;
    }

    public String toString() {
        return this.toBigDecimal().toPlainString();
    }

    @Nullable
    public static Decimal fromBigDecimal(BigDecimal bd, int precision, int scale) {
        if ((bd = bd.setScale(scale, RoundingMode.HALF_UP)).precision() > precision) {
            return null;
        }
        long longVal = -1L;
        if (precision <= 18) {
            longVal = bd.movePointRight(scale).longValueExact();
        }
        return new Decimal(precision, scale, longVal, bd);
    }

    public static Decimal fromUnscaledLong(long unscaledLong, int precision, int scale) {
        Preconditions.checkArgument((precision > 0 && precision <= 18 ? 1 : 0) != 0);
        return new Decimal(precision, scale, unscaledLong, null);
    }

    public static Decimal fromUnscaledBytes(byte[] unscaledBytes, int precision, int scale) {
        BigDecimal bd = new BigDecimal(new BigInteger(unscaledBytes), scale);
        return Decimal.fromBigDecimal(bd, precision, scale);
    }

    @Nullable
    public static Decimal zero(int precision, int scale) {
        if (precision <= 18) {
            return new Decimal(precision, scale, 0L, null);
        }
        return Decimal.fromBigDecimal(BigDecimal.ZERO, precision, scale);
    }

    public static boolean isCompact(int precision) {
        return precision <= 18;
    }

    static {
        Decimal.POW10[0] = 1L;
        for (int i = 1; i < POW10.length; ++i) {
            Decimal.POW10[i] = 10L * POW10[i - 1];
        }
    }
}

