/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen;

import java.io.Serializable;
import org.apache.paimon.codegen.CompileUtils;
import org.apache.paimon.codegen.codesplit.JavaCodeSplitter;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GeneratedClass<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(GeneratedClass.class);
    private final String className;
    private final String code;
    private final String splitCode;
    private final Object[] references;
    private transient Class<T> compiledClass;

    public GeneratedClass(String className, String code) {
        this(className, code, new Object[0]);
    }

    public GeneratedClass(String className, String code, Object[] references) {
        Preconditions.checkNotNull((Object)className, (String)"name must not be null");
        Preconditions.checkNotNull((Object)code, (String)"code must not be null");
        Preconditions.checkNotNull((Object)references, (String)"references must not be null");
        this.className = className;
        this.code = code;
        this.splitCode = code.isEmpty() ? code : JavaCodeSplitter.split(code, 4000, 10000);
        this.references = references;
    }

    public T newInstance(ClassLoader classLoader) {
        try {
            return this.compile(classLoader).getConstructor(Object[].class).newInstance(new Object[]{this.references});
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not instantiate generated class '" + this.className + "'", e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object[] references) {
        try {
            return clazz.getConstructor(Object[].class).newInstance(new Object[]{references});
        }
        catch (Throwable e) {
            throw new RuntimeException("Could not instantiate generated class '" + clazz + "'", e);
        }
    }

    public Class<T> compile(ClassLoader classLoader) {
        if (this.compiledClass == null) {
            try {
                this.compiledClass = CompileUtils.compile(classLoader, this.className, this.splitCode);
            }
            catch (Throwable t) {
                LOG.warn("Failed to compile split code, falling back to original code", t);
                this.compiledClass = CompileUtils.compile(classLoader, this.className, this.code);
            }
        }
        return this.compiledClass;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCode() {
        return this.code;
    }

    public Object[] getReferences() {
        return this.references;
    }

    public Class<T> getClass(ClassLoader classLoader) {
        return this.compile(classLoader);
    }
}

