/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.meta;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.Field;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.meta.AuditInfo;

public class FilesetEntity
implements Entity,
Auditable,
HasIdentifier {
    public static final Field ID = Field.required("id", Long.class, "The unique id of the fileset entity.");
    public static final Field NAME = Field.required("name", String.class, "The name of the fileset entity.");
    public static final Field COMMENT = Field.optional("comment", String.class, "The comment or description of the fileset entity.");
    public static final Field TYPE = Field.required("type", Fileset.Type.class, "The type of the fileset entity.");
    public static final Field STORAGE_LOCATIONS = Field.required("storage_locations", Map.class, "The storage locations of the fileset entity.");
    public static final Field AUDIT_INFO = Field.required("audit_info", AuditInfo.class, "The audit details of the fileset entity.");
    public static final Field PROPERTIES = Field.optional("properties", Map.class, "The properties of the fileset entity.");
    private Long id;
    private String name;
    private Namespace namespace;
    private String comment;
    private Fileset.Type type;
    private Map<String, String> storageLocations = Maps.newHashMap();
    private AuditInfo auditInfo;
    private Map<String, String> properties;

    private FilesetEntity() {
    }

    @Override
    public Map<Field, Object> fields() {
        HashMap fields = Maps.newHashMap();
        fields.put(ID, this.id);
        fields.put(NAME, this.name);
        fields.put(COMMENT, this.comment);
        fields.put(TYPE, this.type);
        fields.put(STORAGE_LOCATIONS, this.storageLocations);
        fields.put(AUDIT_INFO, this.auditInfo);
        fields.put(PROPERTIES, this.properties);
        return Collections.unmodifiableMap(fields);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Namespace namespace() {
        return this.namespace;
    }

    @Override
    public Long id() {
        return this.id;
    }

    public AuditInfo auditInfo() {
        return this.auditInfo;
    }

    @Override
    public Entity.EntityType type() {
        return Entity.EntityType.FILESET;
    }

    public String comment() {
        return this.comment;
    }

    public Fileset.Type filesetType() {
        return this.type;
    }

    public String storageLocation() {
        return this.storageLocations.get("unknown");
    }

    public Map<String, String> storageLocations() {
        return this.storageLocations;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        Entity.super.validate();
        Preconditions.checkArgument((!this.storageLocations.isEmpty() ? 1 : 0) != 0, (Object)"The storage locations of the fileset entity must not be empty.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FilesetEntity)) {
            return false;
        }
        FilesetEntity that = (FilesetEntity)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.comment, that.comment) && Objects.equals(this.type, that.type) && Objects.equals(this.storageLocations, that.storageLocations) && Objects.equals(this.auditInfo, that.auditInfo) && Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.comment, this.type, this.storageLocations, this.auditInfo, this.properties);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "FilesetEntity(id=" + this.id + ", name=" + this.name + ", namespace=" + String.valueOf(this.namespace) + ", comment=" + this.comment + ", type=" + String.valueOf(this.type) + ", storageLocations=" + String.valueOf(this.storageLocations) + ", auditInfo=" + String.valueOf(this.auditInfo) + ", properties=" + String.valueOf(this.properties) + ")";
    }

    public static class Builder {
        private final FilesetEntity fileset = new FilesetEntity();

        private Builder() {
        }

        public Builder withId(Long id) {
            this.fileset.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.fileset.name = name;
            return this;
        }

        public Builder withNamespace(Namespace namespace) {
            this.fileset.namespace = namespace;
            return this;
        }

        public Builder withComment(String comment) {
            this.fileset.comment = comment;
            return this;
        }

        public Builder withFilesetType(Fileset.Type type) {
            this.fileset.type = type;
            return this;
        }

        public Builder withStorageLocations(Map<String, String> storageLocations) {
            this.fileset.storageLocations = ImmutableMap.copyOf(storageLocations);
            return this;
        }

        public Builder withAuditInfo(AuditInfo auditInfo) {
            this.fileset.auditInfo = auditInfo;
            return this;
        }

        public Builder withProperties(Map<String, String> properties) {
            this.fileset.properties = properties;
            return this;
        }

        public FilesetEntity build() {
            this.fileset.validate();
            return this.fileset;
        }
    }
}

