/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.operation.Operation;
import java.util.Objects;
import org.apache.arrow.c.ArrowSchema;
import org.apache.arrow.c.Data;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.pojo.Schema;

public abstract class SchemaOperation
implements Operation {
    private final Schema schema;
    private ArrowSchema cSchema;

    protected SchemaOperation(Schema schema) {
        this.schema = schema;
    }

    public Schema schema() {
        return this.schema;
    }

    public long exportSchema(BufferAllocator allocator) {
        if (this.cSchema == null) {
            this.cSchema = ArrowSchema.allocateNew((BufferAllocator)allocator);
            Data.exportSchema((BufferAllocator)allocator, (Schema)this.schema, null, (ArrowSchema)this.cSchema);
        }
        return this.cSchema.memoryAddress();
    }

    @Override
    public void release() {
        if (this.cSchema != null) {
            this.cSchema.close();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaOperation that = (SchemaOperation)o;
        return Objects.equals(this.schema, that.schema);
    }
}

