/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.operation;

import com.lancedb.lance.fragment.DataFile;
import com.lancedb.lance.operation.Operation;
import java.util.List;
import java.util.Objects;

public class DataReplacement
implements Operation {
    private final List<DataReplacementGroup> replacements;

    private DataReplacement(List<DataReplacementGroup> replacements) {
        this.replacements = replacements;
    }

    public List<DataReplacementGroup> replacements() {
        return this.replacements;
    }

    @Override
    public String name() {
        return "DataReplacement";
    }

    public String toString() {
        return "DataReplacement{replacements=" + this.replacements + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataReplacement that = (DataReplacement)o;
        return Objects.equals(this.replacements, that.replacements);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DataReplacementGroup {
        private final long fragmentId;
        private final DataFile replacedFile;

        public DataReplacementGroup(long fragmentId, DataFile replacedFile) {
            this.fragmentId = fragmentId;
            this.replacedFile = replacedFile;
        }

        public long fragmentId() {
            return this.fragmentId;
        }

        public DataFile replacedFile() {
            return this.replacedFile;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DataReplacementGroup that = (DataReplacementGroup)o;
            return this.fragmentId == that.fragmentId && Objects.equals(this.replacedFile, that.replacedFile);
        }

        public int hashCode() {
            return Objects.hash(this.fragmentId, this.replacedFile);
        }

        public String toString() {
            return "DataReplacementGroup{fragmentId=" + this.fragmentId + ", replacedFile=" + this.replacedFile + '}';
        }
    }

    public static class Builder {
        private List<DataReplacementGroup> replacements;

        public Builder replacements(List<DataReplacementGroup> replacements) {
            this.replacements = replacements;
            return this;
        }

        public DataReplacement build() {
            return new DataReplacement(this.replacements);
        }
    }
}

