/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.client;

import java.util.Collections;
import java.util.Optional;
import org.apache.gravitino.Audit;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.client.ErrorHandlers;
import org.apache.gravitino.client.RESTClient;
import org.apache.gravitino.dto.policy.PolicyDTO;
import org.apache.gravitino.dto.responses.MetadataObjectListResponse;
import org.apache.gravitino.dto.util.DTOConverters;
import org.apache.gravitino.policy.Policy;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.rest.RESTUtils;

class GenericPolicy
implements Policy,
Policy.AssociatedObjects {
    private final PolicyDTO policyDTO;
    private final PolicyContent content;
    private final RESTClient restClient;
    private final String metalake;

    GenericPolicy(PolicyDTO policyDTO, RESTClient restClient, String metalake) {
        this.policyDTO = policyDTO;
        this.content = DTOConverters.fromDTO(policyDTO.content());
        this.restClient = restClient;
        this.metalake = metalake;
    }

    @Override
    public String name() {
        return this.policyDTO.name();
    }

    @Override
    public String policyType() {
        return this.policyDTO.policyType();
    }

    @Override
    public String comment() {
        return this.policyDTO.comment();
    }

    @Override
    public boolean enabled() {
        return this.policyDTO.enabled();
    }

    @Override
    public PolicyContent content() {
        return this.content;
    }

    @Override
    public Optional<Boolean> inherited() {
        return this.policyDTO.inherited();
    }

    @Override
    public Audit auditInfo() {
        return this.policyDTO.auditInfo();
    }

    @Override
    public Policy.AssociatedObjects associatedObjects() {
        return this;
    }

    @Override
    public MetadataObject[] objects() {
        MetadataObjectListResponse resp = this.restClient.get(String.format("api/metalakes/%s/policies/%s/objects", RESTUtils.encodeString(this.metalake), RESTUtils.encodeString(this.name())), MetadataObjectListResponse.class, Collections.emptyMap(), ErrorHandlers.policyErrorHandler());
        resp.validate();
        return resp.getMetadataObjects();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GenericPolicy)) {
            return false;
        }
        GenericPolicy that = (GenericPolicy)obj;
        return this.policyDTO.equals(that.policyDTO);
    }

    public int hashCode() {
        return this.policyDTO.hashCode();
    }

    public String toString() {
        return "GenericPolicy{policyDTO=" + String.valueOf(this.policyDTO) + ", content=" + String.valueOf(this.content) + ", metalake='" + this.metalake + "'}";
    }
}

