/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.session;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.gravitino.storage.relational.session.SqlSessionFactoryHelper;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.TransactionIsolationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlSessions {
    private static final Logger LOG = LoggerFactory.getLogger(SqlSessions.class);
    private static final ThreadLocal<SqlSession> sessions = new ThreadLocal();
    private static final ThreadLocal<AtomicInteger> sessionCount = ThreadLocal.withInitial(() -> new AtomicInteger(0));

    private SqlSessions() {
    }

    @VisibleForTesting
    static ThreadLocal<SqlSession> getSessions() {
        return sessions;
    }

    @VisibleForTesting
    static Integer getSessionCount() {
        return sessionCount.get().get();
    }

    public static SqlSession getSqlSession() {
        SqlSession sqlSession = sessions.get();
        if (sqlSession == null) {
            sqlSession = SqlSessionFactoryHelper.getInstance().getSqlSessionFactory().openSession(TransactionIsolationLevel.READ_COMMITTED);
            sessions.set(sqlSession);
        }
        sessionCount.get().incrementAndGet();
        return sqlSession;
    }

    public static void commitAndCloseSqlSession() {
        SqlSessions.handleSessionClose(true, false);
    }

    public static void rollbackAndCloseSqlSession() {
        SqlSessions.handleSessionClose(false, true);
    }

    public static void closeSqlSession() {
        SqlSessions.handleSessionClose(false, false);
    }

    public static <T> T getMapper(Class<T> className) {
        return (T)SqlSessions.getSqlSession().getMapper(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void handleSessionClose(boolean commit, boolean rollback) {
        SqlSession sqlSession = sessions.get();
        if (sqlSession == null) {
            return;
        }
        int count = sessionCount.get().decrementAndGet();
        if (count == 0) {
            try {
                if (commit) {
                    sqlSession.commit();
                    return;
                }
                if (!rollback) return;
                sqlSession.rollback();
                return;
            }
            finally {
                try {
                    sqlSession.close();
                }
                finally {
                    sessions.remove();
                    sessionCount.remove();
                }
            }
        }
        if (count >= 0) return;
        LOG.warn("Session count is negative: {}. Resetting session count and removing session.", (Object)count);
        sessions.remove();
        sessionCount.remove();
    }
}

