package org.apache.fineract.client.services;

import org.apache.fineract.client.CollectionFormats.*;

    import retrofit2.Call;
import retrofit2.http.*;

import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import okhttp3.MultipartBody;

import org.apache.fineract.client.models.CollateralManagementData;
import org.apache.fineract.client.models.CollateralManagementProductRequest;
import org.apache.fineract.client.models.CollateralProductRequest;
import org.apache.fineract.client.models.CurrencyData;
import org.apache.fineract.client.models.DeleteCollateralProductResponse;
import org.apache.fineract.client.models.PostCollateralManagementProductResponse;
import org.apache.fineract.client.models.PutCollateralProductResponse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface CollateralManagementApi {
    /**
    * Create a new collateral
    * Collateral Creation
        * @param collateralManagementProductRequest  (required)
    * @return Call&lt;PostCollateralManagementProductResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @POST("v1/collateral-management")
    Call<PostCollateralManagementProductResponse> createCollateral1(@retrofit2.http.Body CollateralManagementProductRequest collateralManagementProductRequest);

    /**
    * Delete a Collateral
    * Delete Collateral
        * @param collateralId collateralId (required)
    * @return Call&lt;DeleteCollateralProductResponse&gt;
    */
    @DELETE("v1/collateral-management/{collateralId}")
    Call<DeleteCollateralProductResponse> deleteCollateral2(@retrofit2.http.Path("collateralId") Long collateralId);

    /**
    * Get All Collaterals
    * Fetch all Collateral Products
    * @return Call&lt;List&lt;CollateralManagementData&gt;&gt;
    */
    @GET("v1/collateral-management")
    Call<List<CollateralManagementData>> getAllCollaterals();

    /**
    * Get Collateral
    * Fetch Collateral
        * @param collateralId collateralId (required)
    * @return Call&lt;CollateralManagementData&gt;
    */
    @GET("v1/collateral-management/{collateralId}")
    Call<CollateralManagementData> getCollateral(@retrofit2.http.Path("collateralId") Long collateralId);

    /**
    * Get Collateral Template
    * Get Collateral Template
    * @return Call&lt;List&lt;CurrencyData&gt;&gt;
    */
    @GET("v1/collateral-management/template")
    Call<List<CurrencyData>> getCollateralTemplate();

    /**
    * Update Collateral
    * Update Collateral
        * @param collateralId collateralId (required)
        * @param collateralProductRequest  (required)
    * @return Call&lt;PutCollateralProductResponse&gt;
    */
                @Headers({
                "Content-Type:application/json"
                })
    @PUT("v1/collateral-management/{collateralId}")
    Call<PutCollateralProductResponse> updateCollateral2(@retrofit2.http.Path("collateralId") Long collateralId, @retrofit2.http.Body CollateralProductRequest collateralProductRequest);



        /**
        * Create a new collateral
        * Collateral Creation
            * @param collateralManagementProductRequest  (required)
        * @return Call&lt;PostCollateralManagementProductResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @POST("v1/collateral-management")
    Call<PostCollateralManagementProductResponse> createCollateral1(@retrofit2.http.Body CollateralManagementProductRequest collateralManagementProductRequest, @HeaderMap Map<String, String> headers);

        /**
        * Delete a Collateral
        * Delete Collateral
            * @param collateralId collateralId (required)
        * @return Call&lt;DeleteCollateralProductResponse&gt;
        */
    @DELETE("v1/collateral-management/{collateralId}")
    Call<DeleteCollateralProductResponse> deleteCollateral2(@retrofit2.http.Path("collateralId") Long collateralId, @HeaderMap Map<String, String> headers);

        /**
        * Get All Collaterals
        * Fetch all Collateral Products
        * @return Call&lt;List&lt;CollateralManagementData&gt;&gt;
        */
    @GET("v1/collateral-management")
    Call<List<CollateralManagementData>> getAllCollaterals(@HeaderMap Map<String, String> headers);

        /**
        * Get Collateral
        * Fetch Collateral
            * @param collateralId collateralId (required)
        * @return Call&lt;CollateralManagementData&gt;
        */
    @GET("v1/collateral-management/{collateralId}")
    Call<CollateralManagementData> getCollateral(@retrofit2.http.Path("collateralId") Long collateralId, @HeaderMap Map<String, String> headers);

        /**
        * Get Collateral Template
        * Get Collateral Template
        * @return Call&lt;List&lt;CurrencyData&gt;&gt;
        */
    @GET("v1/collateral-management/template")
    Call<List<CurrencyData>> getCollateralTemplate(@HeaderMap Map<String, String> headers);

        /**
        * Update Collateral
        * Update Collateral
            * @param collateralId collateralId (required)
            * @param collateralProductRequest  (required)
        * @return Call&lt;PutCollateralProductResponse&gt;
        */
                    @Headers({
                    "Content-Type:application/json"
                    })
    @PUT("v1/collateral-management/{collateralId}")
    Call<PutCollateralProductResponse> updateCollateral2(@retrofit2.http.Path("collateralId") Long collateralId, @retrofit2.http.Body CollateralProductRequest collateralProductRequest, @HeaderMap Map<String, String> headers);


}
