/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.self.pockets.domain;

import org.apache.fineract.portfolio.self.pockets.domain.Pocket;
import org.apache.fineract.portfolio.self.pockets.domain.PocketRepository;
import org.apache.fineract.portfolio.self.pockets.exception.PocketNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PocketRepositoryWrapper {
    private final PocketRepository pocketRepository;

    @Autowired
    public PocketRepositoryWrapper(PocketRepository pocketRepository) {
        this.pocketRepository = pocketRepository;
    }

    public void saveAndFlush(Pocket pocket) {
        this.pocketRepository.saveAndFlush((Object)pocket);
    }

    public Long findByAppUserId(Long appUserId) {
        return this.pocketRepository.findByAppUserId(appUserId);
    }

    public Long findByAppUserIdWithNotFoundDetection(Long appUserId) {
        Long pocketId = this.pocketRepository.findByAppUserId(appUserId);
        if (pocketId == null) {
            throw new PocketNotFoundException();
        }
        return pocketId;
    }
}

