/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.savings.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Entity;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.math.MathContext;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.monetary.domain.Money;
import org.apache.fineract.portfolio.savings.domain.DepositRecurringDetail;
import org.apache.fineract.portfolio.savings.domain.RecurringDepositAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;

/*
 * Exception performing whole class analysis ignored.
 */
@Entity
@Table(name="m_deposit_account_recurring_detail")
public class DepositAccountRecurringDetail
extends AbstractPersistableCustom<Long>
implements PersistenceWeaved,
PersistenceObject,
PersistenceWeavedFetchGroups,
PersistenceWeavedChangeTracking {
    @Column(name="mandatory_recommended_deposit_amount", scale=6, precision=19, nullable=true)
    private BigDecimal mandatoryRecommendedDepositAmount;
    @Column(name="total_overdue_amount", scale=6, precision=19, nullable=true)
    private BigDecimal totalOverdueAmount;
    @Column(name="is_calendar_inherited", nullable=false)
    private boolean isCalendarInherited;
    @Column(name="no_of_overdue_installments", nullable=true)
    private Integer noOfOverdueInstallments;
    @Embedded
    private DepositRecurringDetail recurringDetail;
    @OneToOne
    @JoinColumn(name="savings_account_id", nullable=false)
    private SavingsAccount account;
    static final long serialVersionUID = -4778199495237612554L;

    public DepositAccountRecurringDetail() {
        this.noOfOverdueInstallments = 0;
        this.isCalendarInherited = false;
    }

    public static DepositAccountRecurringDetail createNew(BigDecimal mandatoryRecommendedDepositAmount, DepositRecurringDetail recurringDetail, SavingsAccount account, boolean isCalendarInherited) {
        BigDecimal totalOverdueAmount = null;
        Integer noOfOverdueInstallments = null;
        return new DepositAccountRecurringDetail(mandatoryRecommendedDepositAmount, totalOverdueAmount, noOfOverdueInstallments, recurringDetail, account, isCalendarInherited);
    }

    protected DepositAccountRecurringDetail(BigDecimal mandatoryRecommendedDepositAmount, BigDecimal totalOverdueAmount, Integer noOfOverdueInstallments, DepositRecurringDetail recurringDetail, SavingsAccount account, boolean isCalendarInherited) {
        this.mandatoryRecommendedDepositAmount = mandatoryRecommendedDepositAmount;
        this.totalOverdueAmount = totalOverdueAmount;
        this.noOfOverdueInstallments = noOfOverdueInstallments;
        this.recurringDetail = recurringDetail;
        this.account = account;
        this.isCalendarInherited = isCalendarInherited;
    }

    public Map<String, Object> update(JsonCommand command) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(10);
        if (command.isChangeInBigDecimalParameterNamed("mandatoryRecommendedDepositAmount", this._persistence_get_mandatoryRecommendedDepositAmount())) {
            BigDecimal newValue = command.bigDecimalValueOfParameterNamed("mandatoryRecommendedDepositAmount");
            actualChanges.put("mandatoryRecommendedDepositAmount", newValue);
            this._persistence_set_mandatoryRecommendedDepositAmount(newValue);
        }
        if (this._persistence_get_recurringDetail() != null) {
            actualChanges.putAll(this._persistence_get_recurringDetail().update(command));
        }
        return actualChanges;
    }

    public Map<String, Object> updateMandatoryRecommendedDepositAmount(BigDecimal newMandatoryRecommendedDepositAmount, LocalDate effectiveDate, Boolean isSavingsInterestPostingAtCurrentPeriodEnd, Integer financialYearBeginningMonth) {
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(10);
        actualChanges.put("mandatoryRecommendedDepositAmount", newMandatoryRecommendedDepositAmount);
        this._persistence_set_mandatoryRecommendedDepositAmount(newMandatoryRecommendedDepositAmount);
        RecurringDepositAccount depositAccount = (RecurringDepositAccount)this._persistence_get_account();
        if (depositAccount.isNotActive()) {
            String defaultUserMessage = "Updates to the recommended deposit amount are allowed only when the underlying account is active.";
            ApiParameterError error = ApiParameterError.generalError((String)"error.msg.recurringdepositaccount.is.not.active", (String)"Updates to the recommended deposit amount are allowed only when the underlying account is active.", (Object[])new Object[0]);
            ArrayList<ApiParameterError> dataValidationErrors = new ArrayList<ApiParameterError>();
            dataValidationErrors.add(error);
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
        depositAccount.updateScheduleInstallmentsWithNewRecommendedDepositAmount(newMandatoryRecommendedDepositAmount, effectiveDate);
        depositAccount.updateOverduePayments(DateUtils.getBusinessLocalDate());
        MathContext mc = MathContext.DECIMAL64;
        Boolean isPreMatureClosure = false;
        depositAccount.updateMaturityDateAndAmount(mc, isPreMatureClosure.booleanValue(), isSavingsInterestPostingAtCurrentPeriodEnd.booleanValue(), financialYearBeginningMonth);
        return actualChanges;
    }

    public DepositRecurringDetail recurringDetail() {
        return this._persistence_get_recurringDetail();
    }

    public void updateAccountReference(SavingsAccount account) {
        this._persistence_set_account(account);
    }

    public boolean isMandatoryDeposit() {
        return this._persistence_get_recurringDetail().isMandatoryDeposit();
    }

    public boolean allowWithdrawal() {
        return this._persistence_get_recurringDetail().allowWithdrawal();
    }

    public boolean adjustAdvanceTowardsFuturePayments() {
        return this._persistence_get_recurringDetail().adjustAdvanceTowardsFuturePayments();
    }

    public BigDecimal mandatoryRecommendedDepositAmount() {
        return this._persistence_get_mandatoryRecommendedDepositAmount();
    }

    public boolean isCalendarInherited() {
        return this._persistence_get_isCalendarInherited();
    }

    public DepositAccountRecurringDetail copy() {
        BigDecimal mandatoryRecommendedDepositAmount = this._persistence_get_mandatoryRecommendedDepositAmount();
        DepositRecurringDetail recurringDetail = this._persistence_get_recurringDetail().copy();
        boolean isCalendarInherited = this._persistence_get_isCalendarInherited();
        return DepositAccountRecurringDetail.createNew((BigDecimal)mandatoryRecommendedDepositAmount, (DepositRecurringDetail)recurringDetail, null, (boolean)isCalendarInherited);
    }

    public void updateOverdueDetails(int noOfOverdueInstallments, Money totalOverdueAmount) {
        this._persistence_set_noOfOverdueInstallments(Integer.valueOf(noOfOverdueInstallments));
        this._persistence_set_totalOverdueAmount(totalOverdueAmount.getAmount());
    }

    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_listener = null;
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new DepositAccountRecurringDetail(persistenceObject);
    }

    public DepositAccountRecurringDetail(PersistenceObject persistenceObject) {
        super(persistenceObject);
    }

    public Object _persistence_get(String string) {
        if (string == "isCalendarInherited") {
            return this.isCalendarInherited;
        }
        if (string == "noOfOverdueInstallments") {
            return this.noOfOverdueInstallments;
        }
        if (string == "totalOverdueAmount") {
            return this.totalOverdueAmount;
        }
        if (string == "mandatoryRecommendedDepositAmount") {
            return this.mandatoryRecommendedDepositAmount;
        }
        if (string == "account") {
            return this.account;
        }
        if (string == "recurringDetail") {
            return this.recurringDetail;
        }
        return super._persistence_get(string);
    }

    public void _persistence_set(String string, Object object) {
        if (string == "isCalendarInherited") {
            this.isCalendarInherited = (Boolean)object;
            return;
        }
        if (string == "noOfOverdueInstallments") {
            this.noOfOverdueInstallments = (Integer)object;
            return;
        }
        if (string == "totalOverdueAmount") {
            this.totalOverdueAmount = (BigDecimal)object;
            return;
        }
        if (string == "mandatoryRecommendedDepositAmount") {
            this.mandatoryRecommendedDepositAmount = (BigDecimal)object;
            return;
        }
        if (string == "account") {
            this.account = (SavingsAccount)object;
            return;
        }
        if (string == "recurringDetail") {
            this.recurringDetail = (DepositRecurringDetail)object;
            return;
        }
        super._persistence_set(string, object);
    }

    public boolean _persistence_get_isCalendarInherited() {
        this._persistence_checkFetched("isCalendarInherited");
        return this.isCalendarInherited;
    }

    public void _persistence_set_isCalendarInherited(boolean bl) {
        this._persistence_checkFetchedForSet("isCalendarInherited");
        this._persistence_propertyChange("isCalendarInherited", (Object)new Boolean(this.isCalendarInherited), (Object)new Boolean(bl));
        this.isCalendarInherited = bl;
    }

    public Integer _persistence_get_noOfOverdueInstallments() {
        this._persistence_checkFetched("noOfOverdueInstallments");
        return this.noOfOverdueInstallments;
    }

    public void _persistence_set_noOfOverdueInstallments(Integer n) {
        this._persistence_checkFetchedForSet("noOfOverdueInstallments");
        this._persistence_propertyChange("noOfOverdueInstallments", (Object)this.noOfOverdueInstallments, (Object)n);
        this.noOfOverdueInstallments = n;
    }

    public BigDecimal _persistence_get_totalOverdueAmount() {
        this._persistence_checkFetched("totalOverdueAmount");
        return this.totalOverdueAmount;
    }

    public void _persistence_set_totalOverdueAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("totalOverdueAmount");
        this._persistence_propertyChange("totalOverdueAmount", (Object)this.totalOverdueAmount, (Object)bigDecimal);
        this.totalOverdueAmount = bigDecimal;
    }

    public BigDecimal _persistence_get_mandatoryRecommendedDepositAmount() {
        this._persistence_checkFetched("mandatoryRecommendedDepositAmount");
        return this.mandatoryRecommendedDepositAmount;
    }

    public void _persistence_set_mandatoryRecommendedDepositAmount(BigDecimal bigDecimal) {
        this._persistence_checkFetchedForSet("mandatoryRecommendedDepositAmount");
        this._persistence_propertyChange("mandatoryRecommendedDepositAmount", (Object)this.mandatoryRecommendedDepositAmount, (Object)bigDecimal);
        this.mandatoryRecommendedDepositAmount = bigDecimal;
    }

    public SavingsAccount _persistence_get_account() {
        this._persistence_checkFetched("account");
        return this.account;
    }

    public void _persistence_set_account(SavingsAccount savingsAccount) {
        this._persistence_checkFetchedForSet("account");
        this._persistence_propertyChange("account", (Object)this.account, (Object)savingsAccount);
        this.account = savingsAccount;
    }

    public DepositRecurringDetail _persistence_get_recurringDetail() {
        this._persistence_checkFetched("recurringDetail");
        return this.recurringDetail;
    }

    public void _persistence_set_recurringDetail(DepositRecurringDetail depositRecurringDetail) {
        this._persistence_checkFetchedForSet("recurringDetail");
        this._persistence_propertyChange("recurringDetail", (Object)this.recurringDetail, (Object)depositRecurringDetail);
        this.recurringDetail = depositRecurringDetail;
    }
}

