/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.repaymentwithpostdatedchecks.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepaymentScheduleInstallment;
import org.apache.fineract.portfolio.repaymentwithpostdatedchecks.domain.PostDatedChecks;

public class RepaymentWithPostDatedChecksAssembler {
    private final FromJsonHelper fromApiJsonHelper;

    public Set<PostDatedChecks> fromParsedJson(String json, Loan loan) {
        HashSet<PostDatedChecks> postDatedChecks = new HashSet<PostDatedChecks>();
        JsonElement jsonElement = this.fromApiJsonHelper.parse(json);
        List loanRepaymentScheduleInstallments = loan.getRepaymentScheduleInstallments();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(jsonObject);
        if (jsonObject.has("postDatedChecks") && jsonObject.get("postDatedChecks").isJsonArray()) {
            JsonArray postDatedCheckArray = jsonObject.get("postDatedChecks").getAsJsonArray();
            for (int i = 0; i < postDatedCheckArray.size(); ++i) {
                JsonObject postDatedCheck = postDatedCheckArray.get(i).getAsJsonObject();
                if (postDatedCheck == null) continue;
                String name = this.fromApiJsonHelper.extractStringNamed("name", (JsonElement)postDatedCheck);
                BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed("amount", (JsonElement)postDatedCheck, locale);
                Integer installmentId = this.fromApiJsonHelper.extractIntegerNamed("installmentId", (JsonElement)postDatedCheck, locale);
                List installmentList = loanRepaymentScheduleInstallments.stream().filter(repayment -> repayment.getInstallmentNumber().equals(installmentId)).collect(Collectors.toList());
                Long accountNo = this.fromApiJsonHelper.extractLongNamed("accountNo", (JsonElement)postDatedCheck);
                Long checkNo = this.fromApiJsonHelper.extractLongNamed("checkNo", (JsonElement)postDatedCheck);
                postDatedChecks.add(PostDatedChecks.instanceOf((Long)accountNo, (String)name, (BigDecimal)amount, (LoanRepaymentScheduleInstallment)((LoanRepaymentScheduleInstallment)installmentList.get(0)), (Loan)loan, (Long)checkNo));
            }
        }
        return postDatedChecks;
    }

    @Generated
    public RepaymentWithPostDatedChecksAssembler(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

