/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.rate.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fineract.portfolio.rate.domain.Rate;
import org.apache.fineract.portfolio.rate.domain.RateRepository;
import org.apache.fineract.portfolio.rate.exception.RateNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RateRepositoryWrapper {
    private final RateRepository repository;

    @Autowired
    public RateRepositoryWrapper(RateRepository repository) {
        this.repository = repository;
    }

    public Rate findOneWithNotFoundDetection(Long rateId) {
        Rate rate = (Rate)this.repository.findById((Object)rateId).orElseThrow(() -> new RateNotFoundException(rateId));
        return rate;
    }

    public List<Rate> findMultipleWithNotFoundDetection(List<Long> rateIds) {
        ArrayList<Rate> rates = new ArrayList<Rate>();
        if (rateIds != null && !rateIds.isEmpty()) {
            List foundRates = this.repository.findAllById(rateIds);
            for (Long rateId : rateIds) {
                Boolean found = false;
                for (Rate foundRate : foundRates) {
                    if (!Objects.equals(foundRate.getId(), rateId)) continue;
                    found = true;
                    break;
                }
                if (found.booleanValue()) continue;
                throw new RateNotFoundException(rateId);
            }
            rates.addAll(foundRates);
        }
        return rates;
    }
}

