/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.interestratechart.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.common.domain.ConditionType;
import org.apache.fineract.portfolio.interestratechart.incentive.InterestIncentiveAttributeName;
import org.apache.fineract.portfolio.interestratechart.incentive.InterestIncentiveEntityType;
import org.apache.fineract.portfolio.interestratechart.incentive.InterestIncentiveType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InterestIncentiveDataValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> INTERESTRATE_INCENTIVE_CREATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "entityType", "attributeName", "conditionType", "attributeValue", "incentiveType", "amount"));
    private static final Set<String> INTERESTRATE_INCENTIVE_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "entityType", "attributeName", "conditionType", "attributeValue", "incentiveType", "amount"));

    @Autowired
    public InterestIncentiveDataValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateCreate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INTERESTRATE_INCENTIVE_CREATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("interest.rate.incentives");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject objectElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(objectElement);
        this.validateIncentiveCreate(element, baseDataValidator, locale);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateIncentiveCreate(JsonElement element, DataValidatorBuilder baseDataValidator, Locale locale) {
        Integer entityType = this.fromApiJsonHelper.extractIntegerNamed("entityType", element, locale);
        baseDataValidator.reset().parameter("entityType").value((Object)entityType).notNull().isOneOfTheseValues(InterestIncentiveEntityType.integerValues());
        Integer attributeName = this.fromApiJsonHelper.extractIntegerNamed("attributeName", element, locale);
        baseDataValidator.reset().parameter("attributeName").value((Object)attributeName).notNull().isOneOfTheseValues(InterestIncentiveAttributeName.integerValues());
        Integer conditionType = this.fromApiJsonHelper.extractIntegerNamed("conditionType", element, locale);
        baseDataValidator.reset().parameter("conditionType").value((Object)conditionType).notNull().isOneOfTheseValues(ConditionType.integerValues());
        String attributeValue = this.fromApiJsonHelper.extractStringNamed("attributeValue", element);
        baseDataValidator.reset().parameter("attributeValue").value((Object)attributeValue).notNull();
        Integer incentiveType = this.fromApiJsonHelper.extractIntegerNamed("incentiveType", element, locale);
        baseDataValidator.reset().parameter("incentiveType").value((Object)incentiveType).notNull().isOneOfTheseValues(InterestIncentiveType.integerValues());
        BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed("amount", element, locale);
        baseDataValidator.reset().parameter("amount").value((Object)amount).notNull();
    }

    public void validateUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)INTERESTRATE_INCENTIVE_UPDATE_REQUEST_DATA_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("interest.rate.incentives");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        JsonObject objectElement = element.getAsJsonObject();
        Locale locale = this.fromApiJsonHelper.extractLocaleParameter(objectElement);
        this.validateIncentiveUpdate(element, baseDataValidator, locale);
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateIncentiveUpdate(JsonElement element, DataValidatorBuilder baseDataValidator, Locale locale) {
        if (this.fromApiJsonHelper.parameterExists("description", element)) {
            String description = this.fromApiJsonHelper.extractStringNamed("description", element);
            baseDataValidator.reset().parameter("description").value((Object)description).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("entityType", element)) {
            Integer entityType = this.fromApiJsonHelper.extractIntegerNamed("entityType", element, locale);
            baseDataValidator.reset().parameter("entityType").value((Object)entityType).notNull().isOneOfTheseValues(InterestIncentiveEntityType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("attributeName", element)) {
            Integer attributeName = this.fromApiJsonHelper.extractIntegerNamed("attributeName", element, locale);
            baseDataValidator.reset().parameter("attributeName").value((Object)attributeName).notNull().isOneOfTheseValues(InterestIncentiveAttributeName.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("conditionType", element)) {
            Integer conditionType = this.fromApiJsonHelper.extractIntegerNamed("conditionType", element, locale);
            baseDataValidator.reset().parameter("conditionType").value((Object)conditionType).notNull().isOneOfTheseValues(ConditionType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("attributeValue", element)) {
            String attributeValue = this.fromApiJsonHelper.extractStringNamed("attributeValue", element);
            baseDataValidator.reset().parameter("attributeValue").value((Object)attributeValue).notNull();
        }
        if (this.fromApiJsonHelper.parameterExists("incentiveType", element)) {
            Integer incentiveType = this.fromApiJsonHelper.extractIntegerNamed("incentiveType", element, locale);
            baseDataValidator.reset().parameter("incentiveType").value((Object)incentiveType).notNull().isOneOfTheseValues(InterestIncentiveType.integerValues());
        }
        if (this.fromApiJsonHelper.parameterExists("amount", element)) {
            BigDecimal amount = this.fromApiJsonHelper.extractBigDecimalNamed("amount", element, locale);
            baseDataValidator.reset().parameter("amount").value((Object)amount).notNull();
        }
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

