/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.workingdays.data;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkingDayValidator {
    private final FromJsonHelper fromApiJsonHelper;
    private static final Set<String> WORKING_DAYS_CREATE_OR_UPDATE_REQUEST_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("recurrence", "repaymentRescheduleType", "locale", "extendTermForDailyRepayments", "extendTermForRepaymentsOnHolidays"));

    @Autowired
    public WorkingDayValidator(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)WORKING_DAYS_CREATE_OR_UPDATE_REQUEST_DATA_PARAMETERS);
        JsonElement element = this.fromApiJsonHelper.parse(json);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("workingdays");
        String recurrence = this.fromApiJsonHelper.extractStringNamed("recurrence", element);
        baseDataValidator.reset().parameter("recurrence").value((Object)recurrence).notNull();
        Integer repaymentRescheduleType = this.fromApiJsonHelper.extractIntegerSansLocaleNamed("repaymentRescheduleType", element);
        baseDataValidator.reset().parameter("repaymentRescheduleType").value((Object)repaymentRescheduleType).ignoreIfNull().inMinMaxRange(Integer.valueOf(1), Integer.valueOf(4));
        Boolean extendTermForDailyRepayments = this.fromApiJsonHelper.extractBooleanNamed("extendTermForDailyRepayments", element);
        baseDataValidator.reset().parameter("extendTermForDailyRepayments").value((Object)extendTermForDailyRepayments).ignoreIfNull().validateForBooleanValue();
        Boolean extendTermForRepaymentsOnHolidays = this.fromApiJsonHelper.extractBooleanNamed("extendTermForRepaymentsOnHolidays", element);
        baseDataValidator.reset().parameter("extendTermForRepaymentsOnHolidays").value((Object)extendTermForRepaymentsOnHolidays).ignoreIfNull().validateForBooleanValue();
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException(dataValidationErrors);
        }
    }
}

