/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.dataqueries.service.export;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.File;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.dataqueries.service.DatatableExportTargetParameter;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.dataqueries.service.export.DatatableReportExportService;
import org.apache.fineract.infrastructure.dataqueries.service.export.ResponseHolder;
import org.springframework.stereotype.Service;

@Service
public class PdfDatatableReportExportService
implements DatatableReportExportService {
    private final ReadReportingService readExtraDataAndReportingService;

    public ResponseHolder export(String reportName, MultivaluedMap<String, String> queryParams, Map<String, String> reportParams, boolean isSelfServiceUserReport, String parameterTypeValue) {
        String pdfFileName = this.readExtraDataAndReportingService.retrieveReportPDF(reportName, parameterTypeValue, reportParams, isSelfServiceUserReport);
        File file = new File(pdfFileName);
        return new ResponseHolder(Response.Status.OK).contentType("application/pdf").addHeader("Content-Disposition", "attachment; filename=\"" + pdfFileName + "\"").entity((Object)file);
    }

    public boolean supports(DatatableExportTargetParameter exportType) {
        return exportType == DatatableExportTargetParameter.PDF;
    }

    @Generated
    public PdfDatatableReportExportService(ReadReportingService readExtraDataAndReportingService) {
        this.readExtraDataAndReportingService = readExtraDataAndReportingService;
    }
}

