/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.jersey.converter;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.fineract.infrastructure.core.jersey.converter.JsonConverter;
import org.springframework.stereotype.Component;

@Component
public class LocalTimeJsonConverter
implements JsonConverter<LocalTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_LOCAL_TIME;

    public LocalTime convertToObject(JsonParser parser) throws IOException {
        LocalTime result = null;
        if (parser.hasToken(JsonToken.VALUE_STRING)) {
            String formattedDate = parser.getText();
            result = LocalTime.parse(formattedDate, FORMATTER);
        }
        return result;
    }

    public void convertToJson(LocalTime value, JsonGenerator generator) throws IOException {
        if (value != null) {
            generator.writeString(FORMATTER.format(value));
        }
    }

    public Class<LocalTime> convertedType() {
        return LocalTime.class;
    }
}

