/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import java.util.Collection;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.sms.data.MessageGatewayConfigurationData;
import org.apache.fineract.infrastructure.configuration.data.ExternalServicesPropertiesData;
import org.apache.fineract.infrastructure.configuration.data.S3CredentialsData;
import org.apache.fineract.infrastructure.configuration.data.SMTPCredentialsData;
import org.apache.fineract.infrastructure.configuration.exception.ExternalServiceConfigurationNotFoundException;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesPropertiesReadPlatformService;
import org.apache.fineract.infrastructure.configuration.service.ExternalServicesPropertiesReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.gcm.domain.NotificationConfigurationData;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ExternalServicesPropertiesReadPlatformServiceImpl
implements ExternalServicesPropertiesReadPlatformService {
    private final JdbcTemplate jdbcTemplate;

    public S3CredentialsData getS3Credentials() {
        S3CredentialsDataExtractor resultSetExtractor = new S3CredentialsDataExtractor();
        String sql = "SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'S3'";
        S3CredentialsData s3CredentialsData = (S3CredentialsData)this.jdbcTemplate.query("SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'S3'", (ResultSetExtractor)resultSetExtractor, new Object[0]);
        return s3CredentialsData;
    }

    public SMTPCredentialsData getSMTPCredentials() {
        SMTPCredentialsDataExtractor resultSetExtractor = new SMTPCredentialsDataExtractor();
        String sql = "SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'SMTP_Email_Account'";
        SMTPCredentialsData smtpCredentialsData = (SMTPCredentialsData)this.jdbcTemplate.query("SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'SMTP_Email_Account'", (ResultSetExtractor)resultSetExtractor, new Object[0]);
        return smtpCredentialsData;
    }

    public MessageGatewayConfigurationData getSMSGateway() {
        MessageGatewayDataExtractor resultSetExtractor = new MessageGatewayDataExtractor();
        String sql = "SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'MESSAGE_GATEWAY'";
        MessageGatewayConfigurationData messageGatewayConfigurationData = (MessageGatewayConfigurationData)this.jdbcTemplate.query("SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'MESSAGE_GATEWAY'", (ResultSetExtractor)resultSetExtractor, new Object[0]);
        return messageGatewayConfigurationData;
    }

    public Collection<ExternalServicesPropertiesData> retrieveOne(String serviceName) {
        String serviceNameToUse = null;
        switch (serviceName) {
            case "S3": {
                serviceNameToUse = "S3";
                break;
            }
            case "SMTP": {
                serviceNameToUse = "SMTP_Email_Account";
                break;
            }
            case "SMS": {
                serviceNameToUse = "MESSAGE_GATEWAY";
                break;
            }
            case "NOTIFICATION": {
                serviceNameToUse = "NOTIFICATION";
                break;
            }
            default: {
                throw new ExternalServiceConfigurationNotFoundException(serviceName);
            }
        }
        ExternalServiceMapper mapper = new ExternalServiceMapper();
        String sql = "SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = '" + serviceNameToUse + "'";
        return this.jdbcTemplate.query(sql, (RowMapper)mapper);
    }

    public NotificationConfigurationData getNotificationConfiguration() {
        NotificationDataExtractor resultSetExtractor = new NotificationDataExtractor();
        String sql = "SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'NOTIFICATION'";
        NotificationConfigurationData notificationConfigurationData = (NotificationConfigurationData)this.jdbcTemplate.query("SELECT esp.name, esp.value FROM c_external_service_properties esp inner join c_external_service es on esp.external_service_id = es.id where es.name = 'NOTIFICATION'", (ResultSetExtractor)resultSetExtractor, new Object[0]);
        return notificationConfigurationData;
    }

    @Generated
    public ExternalServicesPropertiesReadPlatformServiceImpl(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }
}

