/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.accounting.journalentry.service;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.accounting.glaccount.domain.GLAccountType;
import org.apache.fineract.accounting.journalentry.api.JournalEntryJsonInputParams;
import org.apache.fineract.accounting.journalentry.data.JournalEntryData;
import org.apache.fineract.accounting.journalentry.data.JournalEntryDataValidator;
import org.apache.fineract.accounting.journalentry.domain.JournalEntryType;
import org.apache.fineract.accounting.journalentry.service.JournalEntryRunningBalanceUpdateService;
import org.apache.fineract.accounting.journalentry.service.JournalEntryRunningBalanceUpdateServiceImpl;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class JournalEntryRunningBalanceUpdateServiceImpl
implements JournalEntryRunningBalanceUpdateService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryRunningBalanceUpdateServiceImpl.class);
    private final JdbcTemplate jdbcTemplate;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final JournalEntryDataValidator dataValidator;
    private final FromJsonHelper fromApiJsonHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final GLJournalEntryMapper entryMapper = new GLJournalEntryMapper();
    private final PlatformSecurityContext platformSecurityContext;

    public void updateRunningBalance() {
        String dateFinder = "select MIN(je.entry_date) as entityDate from acc_gl_journal_entry  je where je.is_running_balance_calculated=false ";
        try {
            LocalDate entityDate = (LocalDate)this.jdbcTemplate.queryForObject(dateFinder, LocalDate.class);
            this.updateOrganizationRunningBalance(entityDate);
        }
        catch (EmptyResultDataAccessException e) {
            log.debug("No results found for updation of running balance ");
        }
    }

    public CommandProcessingResult updateOfficeRunningBalance(JsonCommand command) {
        this.dataValidator.validateForUpdateRunningBalance(command);
        Long officeId = this.fromApiJsonHelper.extractLongNamed(JournalEntryJsonInputParams.OFFICE_ID.getValue(), command.parsedJson());
        CommandProcessingResultBuilder commandProcessingResultBuilder = new CommandProcessingResultBuilder().withCommandId(command.commandId());
        if (officeId == null) {
            this.updateRunningBalance();
        } else {
            this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
            String dateFinder = "select MIN(je.entry_date) as entityDate from acc_gl_journal_entry  je where je.is_running_balance_calculated=false  and je.office_id=?";
            try {
                LocalDate entityDate = (LocalDate)this.jdbcTemplate.queryForObject(dateFinder, LocalDate.class, new Object[]{officeId});
                this.updateRunningBalance(officeId, entityDate);
            }
            catch (EmptyResultDataAccessException e) {
                log.debug("No results found for updation of office running balance with office id: {}", (Object)officeId);
            }
            commandProcessingResultBuilder.withOfficeId(officeId);
        }
        return commandProcessingResultBuilder.build();
    }

    private void updateOrganizationRunningBalance(LocalDate entityDate) {
        HashMap<Long, BigDecimal> runningBalanceMap = new HashMap<Long, BigDecimal>(5);
        HashMap<Long, Map<Long, BigDecimal>> officesRunningBalance = new HashMap<Long, Map<Long, BigDecimal>>();
        String organizationRunningBalanceQuery = "select je.organization_running_balance as runningBalance,je.account_id as accountId from acc_gl_journal_entry je inner join (select max(id) as id from acc_gl_journal_entry where entry_date < ? group by account_id,entry_date) je2 ON je2.id = je.id inner join (select max(entry_date) as date from acc_gl_journal_entry where entry_date < ? group by account_id) je3 ON je.entry_date = je3.date group by je.id order by je.entry_date DESC " + this.sqlGenerator.limit(10000, 0);
        List list = this.jdbcTemplate.queryForList(organizationRunningBalanceQuery, new Object[]{entityDate, entityDate});
        for (Map entries : list) {
            Long accountId = Long.parseLong(entries.get("accountId").toString());
            if (runningBalanceMap.containsKey(accountId)) continue;
            runningBalanceMap.put(accountId, (BigDecimal)entries.get("runningBalance"));
        }
        String offlineRunningBalanceQuery = "select je.office_running_balance as runningBalance,je.account_id as accountId,je.office_id as officeId from acc_gl_journal_entry je inner join (select max(id) as id from acc_gl_journal_entry where entry_date < ? group by office_id,account_id,entry_date) je2 ON je2.id = je.id inner join (select max(entry_date) as date from acc_gl_journal_entry where entry_date < ? group by office_id,account_id) je3 ON je.entry_date = je3.date group by je.id order by je.entry_date DESC " + this.sqlGenerator.limit(10000, 0);
        List officesRunningBalanceList = this.jdbcTemplate.queryForList(offlineRunningBalanceQuery, new Object[]{entityDate, entityDate});
        for (Map entries : officesRunningBalanceList) {
            Map<Long, BigDecimal> runningBalance;
            Long accountId = Long.parseLong(entries.get("accountId").toString());
            Long officeId = Long.parseLong(entries.get("officeId").toString());
            if (officesRunningBalance.containsKey(officeId)) {
                runningBalance = (Map)officesRunningBalance.get(officeId);
            } else {
                runningBalance = new HashMap();
                officesRunningBalance.put(officeId, runningBalance);
            }
            if (runningBalance.containsKey(accountId)) continue;
            runningBalance.put(accountId, (BigDecimal)entries.get("runningBalance"));
        }
        List entryDataList = this.jdbcTemplate.query(this.entryMapper.organizationRunningBalanceSchema(), (RowMapper)this.entryMapper, new Object[]{entityDate});
        if (entryDataList.size() > 0) {
            int batchUpdateSize = 1000;
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            int batchIndex = 0;
            String sql = "UPDATE acc_gl_journal_entry SET is_running_balance_calculated=?, organization_running_balance=?,office_running_balance=?, last_modified_by=?, last_modified_on_utc=?  WHERE  id=?";
            for (int index = 0; index < entryDataList.size(); ++index) {
                Map officeRunningBalanceMap;
                JournalEntryData entryData = (JournalEntryData)entryDataList.get(index);
                if (officesRunningBalance.containsKey(entryData.getOfficeId())) {
                    officeRunningBalanceMap = (Map)officesRunningBalance.get(entryData.getOfficeId());
                } else {
                    officeRunningBalanceMap = new HashMap();
                    officesRunningBalance.put(entryData.getOfficeId(), officeRunningBalanceMap);
                }
                BigDecimal officeRunningBalance = this.calculateRunningBalance(entryData, officeRunningBalanceMap);
                BigDecimal runningBalance = this.calculateRunningBalance(entryData, runningBalanceMap);
                params.add(new Object[]{Boolean.TRUE, runningBalance, officeRunningBalance, this.platformSecurityContext.authenticatedUser().getId(), DateUtils.getAuditOffsetDateTime(), entryData.getId()});
                if (++batchIndex != 1000 && index != entryDataList.size() - 1) continue;
                this.jdbcTemplate.batchUpdate(sql, params);
                batchIndex = 0;
                params.clear();
            }
        }
    }

    private void updateRunningBalance(Long officeId, LocalDate entityDate) {
        HashMap<Long, BigDecimal> runningBalanceMap = new HashMap<Long, BigDecimal>(5);
        String offlineRunningBalanceQuery = "select je.office_running_balance as runningBalance,je.account_id as accountId from acc_gl_journal_entry je inner join (select max(id) as id from acc_gl_journal_entry where office_id=?  and entry_date < ? group by account_id,entry_date) je2 ON je2.id = je.id inner join (select max(entry_date) as date from acc_gl_journal_entry where office_id=? and entry_date < ? group by account_id) je3 ON je.entry_date = je3.date group by je.id order by je.entry_date DESC " + this.sqlGenerator.limit(10000, 0);
        List list = this.jdbcTemplate.queryForList(offlineRunningBalanceQuery, new Object[]{officeId, entityDate, officeId, entityDate});
        for (Map entries : list) {
            Long accountId = (Long)entries.get("accountId");
            if (runningBalanceMap.containsKey(accountId)) continue;
            runningBalanceMap.put(accountId, (BigDecimal)entries.get("runningBalance"));
        }
        List entryDataList = this.jdbcTemplate.query(this.entryMapper.officeRunningBalanceSchema(), (RowMapper)this.entryMapper, new Object[]{officeId, entityDate});
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        String sql = "UPDATE acc_gl_journal_entry SET office_running_balance=?, last_modified_by=?, last_modified_on_utc=? WHERE id=?";
        for (JournalEntryData entryData : entryDataList) {
            BigDecimal runningBalance = this.calculateRunningBalance(entryData, runningBalanceMap);
            params.add(new Object[]{runningBalance, this.platformSecurityContext.authenticatedUser().getId(), DateUtils.getAuditOffsetDateTime(), entryData.getId()});
        }
        this.jdbcTemplate.batchUpdate(sql, params);
    }

    private BigDecimal calculateRunningBalance(JournalEntryData entry, Map<Long, BigDecimal> runningBalanceMap) {
        BigDecimal runningBalance = BigDecimal.ZERO;
        if (runningBalanceMap.containsKey(entry.getGlAccountId())) {
            runningBalance = runningBalanceMap.get(entry.getGlAccountId());
        }
        GLAccountType accountType = GLAccountType.fromInt((Integer)((Long)entry.getGlAccountType().getId()).intValue());
        JournalEntryType entryType = JournalEntryType.fromInt((Integer)((Long)entry.getEntryType().getId()).intValue());
        boolean isIncrease = false;
        switch (1.$SwitchMap$org$apache$fineract$accounting$glaccount$domain$GLAccountType[accountType.ordinal()]) {
            case 1: 
            case 2: {
                if (!entryType.isDebitType()) break;
                isIncrease = true;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (!entryType.isCreditType()) break;
                isIncrease = true;
            }
        }
        runningBalance = isIncrease ? runningBalance.add(entry.getAmount()) : runningBalance.subtract(entry.getAmount());
        runningBalanceMap.put(entry.getGlAccountId(), runningBalance);
        return runningBalance;
    }

    @Generated
    public JournalEntryRunningBalanceUpdateServiceImpl(JdbcTemplate jdbcTemplate, OfficeRepositoryWrapper officeRepositoryWrapper, JournalEntryDataValidator dataValidator, FromJsonHelper fromApiJsonHelper, DatabaseSpecificSQLGenerator sqlGenerator, PlatformSecurityContext platformSecurityContext) {
        this.jdbcTemplate = jdbcTemplate;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.dataValidator = dataValidator;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.sqlGenerator = sqlGenerator;
        this.platformSecurityContext = platformSecurityContext;
    }
}

