/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.github.resilience4j.core.InstantiationException;
import io.github.resilience4j.core.lang.Nullable;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public class ClassUtils {
    @Nullable
    public static <T> Predicate<T> instantiatePredicateClass(Class<? extends Predicate<T>> clazz) {
        try {
            Constructor<Predicate<T>> c = clazz.getConstructor(new Class[0]);
            if (c != null) {
                return c.newInstance(new Object[0]);
            }
            throw new InstantiationException("Unable to create instance of class: " + clazz.getName());
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to create instance of class: " + clazz.getName(), e);
        }
    }

    public static <T> T instantiateClassDefConstructor(Class<T> clazz) {
        Objects.requireNonNull(clazz, "class to instantiate should not be null");
        if (clazz.getConstructors().length > 0 && !Arrays.stream(clazz.getConstructors()).filter(c -> c.getParameterCount() == 0).findFirst().isPresent()) {
            throw new InstantiationException("Default constructor is required to create instance of public class: " + clazz.getName());
        }
        try {
            return clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new InstantiationException("Unable to create instance of class: " + clazz.getName(), e);
        }
    }
}

