/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Stopwatch;

@NotThreadSafe
public class LoadingRateTracker {
    public static final int MOVING_AVERAGE_WINDOW_SIZE = 10;
    public static final long MIN_ENTRY_SIZE_BYTES = 0x40000000L;
    private final EvictingQueue<Entry> window = EvictingQueue.create((int)10);
    private final AtomicReference<Entry> windowTotal = new AtomicReference();
    private Entry currentBatchTotal;
    private Entry currentTail;
    private final Stopwatch currentBatchDuration = Stopwatch.createUnstarted();

    public void markBatchLoadingStarted() {
        if (this.isLoadingBatch()) {
            return;
        }
        this.currentBatchDuration.restart();
        this.currentBatchTotal = new Entry();
        Entry evictedHead = this.addNewEntryIfTailIsFull();
        if (evictedHead != null) {
            Entry delta = new Entry();
            delta.bytes -= evictedHead.bytes;
            delta.millisElapsed -= evictedHead.millisElapsed;
            this.windowTotal.updateAndGet(delta::incrementBy);
        }
    }

    public boolean isLoadingBatch() {
        return this.currentBatchDuration.isRunning();
    }

    public void incrementBytesLoadedInBatch(long loadedBytes) {
        this.incrementBytesLoadedInBatch(loadedBytes, this.currentBatchDuration.millisElapsed());
    }

    @VisibleForTesting
    void incrementBytesLoadedInBatch(long bytes, long batchDurationMillis) {
        if (!this.isLoadingBatch()) {
            throw DruidException.defensive((String)"markBatchLoadingStarted() must be called before tracking load progress.", (Object[])new Object[0]);
        }
        Entry delta = new Entry();
        delta.bytes = bytes;
        delta.millisElapsed = batchDurationMillis - this.currentBatchTotal.millisElapsed;
        this.currentTail.incrementBy(delta);
        this.currentBatchTotal.incrementBy(delta);
        this.windowTotal.updateAndGet(delta::incrementBy);
    }

    public void markBatchLoadingFinished() {
        if (this.isLoadingBatch()) {
            this.currentBatchDuration.reset();
            this.currentBatchTotal = null;
        }
    }

    public void stop() {
        this.window.clear();
        this.windowTotal.set(null);
        this.currentTail = null;
        this.currentBatchTotal = null;
        this.currentBatchDuration.reset();
    }

    public long getMovingAverageLoadRateKbps() {
        Entry overallTotal = this.windowTotal.get();
        if (overallTotal == null || overallTotal.millisElapsed <= 0L) {
            return 0L;
        }
        return 8L * overallTotal.bytes / overallTotal.millisElapsed;
    }

    private Entry addNewEntryIfTailIsFull() {
        Entry newHead;
        Entry oldHead = (Entry)this.window.peek();
        if (this.currentTail == null || this.currentTail.bytes >= 0x40000000L) {
            this.currentTail = new Entry();
            this.window.add((Object)this.currentTail);
        }
        return (newHead = (Entry)this.window.peek()) == oldHead ? null : oldHead;
    }

    private static class Entry {
        long bytes;
        long millisElapsed;

        private Entry() {
        }

        Entry incrementBy(Entry delta) {
            if (delta != null) {
                this.bytes += delta.bytes;
                this.millisElapsed += delta.millisElapsed;
            }
            return this;
        }
    }
}

