/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;

public class DruidCompactionConfig {
    public static final String CONFIG_KEY = "coordinator.compaction.config";
    private static final DruidCompactionConfig EMPTY_INSTANCE = new DruidCompactionConfig(List.of(), null, null, null, null, null);
    private final List<DataSourceCompactionConfig> compactionConfigs;
    private final ClusterCompactionConfig clusterConfig;

    public DruidCompactionConfig withDatasourceConfigs(List<DataSourceCompactionConfig> compactionConfigs) {
        return new DruidCompactionConfig(compactionConfigs, this.clusterConfig);
    }

    public DruidCompactionConfig withClusterConfig(ClusterCompactionConfig clusterConfig) {
        return new DruidCompactionConfig(this.compactionConfigs, clusterConfig);
    }

    public DruidCompactionConfig withDatasourceConfig(DataSourceCompactionConfig dataSourceConfig) {
        Map<String, DataSourceCompactionConfig> configs = this.dataSourceToCompactionConfigMap();
        configs.put(dataSourceConfig.getDataSource(), dataSourceConfig);
        return this.withDatasourceConfigs(new ArrayList<DataSourceCompactionConfig>(configs.values()));
    }

    public static DruidCompactionConfig empty() {
        return EMPTY_INSTANCE;
    }

    @JsonCreator
    public DruidCompactionConfig(@JsonProperty(value="compactionConfigs") List<DataSourceCompactionConfig> compactionConfigs, @JsonProperty(value="compactionTaskSlotRatio") @Nullable Double compactionTaskSlotRatio, @JsonProperty(value="maxCompactionTaskSlots") @Nullable Integer maxCompactionTaskSlots, @JsonProperty(value="compactionPolicy") @Nullable CompactionCandidateSearchPolicy compactionPolicy, @JsonProperty(value="useSupervisors") @Nullable Boolean useSupervisors, @JsonProperty(value="engine") @Nullable CompactionEngine engine) {
        this(compactionConfigs, new ClusterCompactionConfig(compactionTaskSlotRatio, maxCompactionTaskSlots, compactionPolicy, useSupervisors, engine));
    }

    private DruidCompactionConfig(@Nullable List<DataSourceCompactionConfig> compactionConfigs, @Nullable ClusterCompactionConfig clusterConfig) {
        this.compactionConfigs = (List)Configs.valueOrDefault(compactionConfigs, Collections.emptyList());
        this.clusterConfig = clusterConfig;
    }

    @JsonProperty
    public List<DataSourceCompactionConfig> getCompactionConfigs() {
        return this.compactionConfigs;
    }

    @JsonProperty
    public double getCompactionTaskSlotRatio() {
        return this.clusterConfig.getCompactionTaskSlotRatio();
    }

    @JsonProperty
    public int getMaxCompactionTaskSlots() {
        return this.clusterConfig.getMaxCompactionTaskSlots();
    }

    @JsonProperty
    public boolean isUseSupervisors() {
        return this.clusterConfig.isUseSupervisors();
    }

    @JsonProperty
    public CompactionEngine getEngine() {
        return this.clusterConfig.getEngine();
    }

    public ClusterCompactionConfig clusterConfig() {
        return this.clusterConfig;
    }

    public Map<String, DataSourceCompactionConfig> dataSourceToCompactionConfigMap() {
        return this.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
    }

    public Optional<DataSourceCompactionConfig> findConfigForDatasource(String dataSource) {
        for (DataSourceCompactionConfig dataSourceConfig : this.getCompactionConfigs()) {
            if (!dataSource.equals(dataSourceConfig.getDataSource())) continue;
            return Optional.of((Object)dataSourceConfig);
        }
        return Optional.absent();
    }

    @JsonProperty
    public CompactionCandidateSearchPolicy getCompactionPolicy() {
        return this.clusterConfig.getCompactionPolicy();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidCompactionConfig that = (DruidCompactionConfig)o;
        return Objects.equals(this.clusterConfig, that.clusterConfig) && Objects.equals(this.compactionConfigs, that.compactionConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.clusterConfig, this.compactionConfigs);
    }

    public String toString() {
        return "CoordinatorCompactionConfig{compactionConfigs=" + this.compactionConfigs + ", clusterConfig=" + this.clusterConfig + "}";
    }
}

