/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.druid.discovery.DataNodeService;
import org.apache.druid.discovery.DruidService;

public class DruidServiceSerializer
extends StdSerializer<DruidService> {
    private final JsonSerializer<Object> defaultSerializer;

    public DruidServiceSerializer(JsonSerializer<Object> defaultSerializer) {
        super(DruidService.class);
        this.defaultSerializer = defaultSerializer;
    }

    public void serialize(DruidService druidService, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        this.defaultSerializer.serialize((Object)druidService, gen, serializers);
    }

    public void serializeWithType(DruidService druidService, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        if (druidService instanceof DataNodeService) {
            DataNodeService dataNodeService = (DataNodeService)druidService;
            gen.writeStartObject();
            gen.writeStringField("type", "dataNodeService");
            gen.writeStringField("tier", dataNodeService.getTier());
            gen.writeNumberField("maxSize", dataNodeService.getMaxSize());
            gen.writeObjectField("type", (Object)dataNodeService.getServerType());
            gen.writeObjectField("serverType", (Object)dataNodeService.getServerType());
            gen.writeNumberField("priority", dataNodeService.getPriority());
            gen.writeEndObject();
        } else {
            this.defaultSerializer.serializeWithType((Object)druidService, gen, serializers, typeSer);
        }
    }
}

