/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class NodeRole {
    public static final String COORDINATOR_JSON_NAME = "coordinator";
    public static final String HISTORICAL_JSON_NAME = "historical";
    public static final String BROKER_JSON_NAME = "broker";
    public static final String OVERLORD_JSON_NAME = "overlord";
    public static final String PEON_JSON_NAME = "peon";
    public static final String ROUTER_JSON_NAME = "router";
    public static final String MIDDLE_MANAGER_JSON_NAME = "middleManager";
    public static final String INDEXER_JSON_NAME = "indexer";
    public static final NodeRole COORDINATOR = new NodeRole("COORDINATOR", "coordinator");
    public static final NodeRole HISTORICAL = new NodeRole("HISTORICAL", "historical");
    public static final NodeRole BROKER = new NodeRole("BROKER", "broker");
    public static final NodeRole OVERLORD = new NodeRole("OVERLORD", "overlord");
    public static final NodeRole PEON = new NodeRole("PEON", "peon");
    public static final NodeRole ROUTER = new NodeRole("ROUTER", "router");
    public static final NodeRole MIDDLE_MANAGER = new NodeRole("MIDDLE_MANAGER", "middleManager");
    public static final NodeRole INDEXER = new NodeRole("INDEXER", "indexer");
    private static final NodeRole[] BUILT_IN = new NodeRole[]{COORDINATOR, HISTORICAL, BROKER, OVERLORD, PEON, ROUTER, MIDDLE_MANAGER, INDEXER};
    private static final Map<String, NodeRole> BUILT_IN_LOOKUP = Arrays.stream(BUILT_IN).collect(Collectors.toMap(NodeRole::getJsonName, Function.identity()));
    private final String name;
    private final String jsonName;

    public NodeRole(String jsonName) {
        this(jsonName, jsonName);
    }

    private NodeRole(String name, String jsonName) {
        this.name = name;
        this.jsonName = jsonName;
    }

    public Named getDruidServiceInjectName() {
        return Names.named((String)this.jsonName);
    }

    @JsonValue
    public String getJsonName() {
        return this.jsonName;
    }

    @JsonCreator
    public static NodeRole fromJsonName(String jsonName) {
        return BUILT_IN_LOOKUP.getOrDefault(jsonName, new NodeRole(jsonName));
    }

    public String toString() {
        return this.name;
    }

    public static NodeRole[] values() {
        return Arrays.copyOf(BUILT_IN, BUILT_IN.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeRole nodeRole = (NodeRole)o;
        return this.name.equals(nodeRole.name) && this.jsonName.equals(nodeRole.jsonName);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.jsonName);
    }
}

